/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormBasedAuthInterceptor
implements HttpRequestInterceptor {
    static final Logger LOG = LoggerFactory.getLogger(FormBasedAuthInterceptor.class);
    private final String loginPath = "j_security_check";
    private final String loginTokenName;

    public FormBasedAuthInterceptor(String loginTokenName) {
        this.loginTokenName = loginTokenName;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        URI uri = URI.create(request.getRequestLine().getUri());
        if (uri.getPath().endsWith("j_security_check")) {
            LOG.debug("Request ends with {} so I'm not intercepting the request", (Object)"j_security_check");
            return;
        }
        Cookie loginCookie = this.getLoginCookie(context, this.loginTokenName);
        if (loginCookie != null) {
            LOG.debug("Request has cookie {}={} so I'm not intercepting the request", (Object)loginCookie.getName(), (Object)loginCookie.getValue());
            return;
        }
        HttpHost host = HttpClientContext.adapt(context).getTargetHost();
        CredentialsProvider credsProvider = HttpClientContext.adapt(context).getCredentialsProvider();
        AuthScope scope = new AuthScope(host.getHostName(), host.getPort());
        String username = credsProvider.getCredentials(scope).getUserPrincipal().getName();
        String password = credsProvider.getCredentials(scope).getPassword();
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("j_username", username));
        parameters.add(new BasicNameValuePair("j_password", password));
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(parameters, "utf-8");
        HttpPost loginPost = new HttpPost(URI.create(request.getRequestLine().getUri()).resolve("j_security_check"));
        loginPost.setEntity(httpEntity);
        CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();
        client.execute(host, (HttpRequest)loginPost, context);
    }

    private Cookie getLoginCookie(HttpContext context, String loginTokenName) {
        for (Cookie cookie : HttpClientContext.adapt(context).getCookieStore().getCookies()) {
            if (!cookie.getName().equalsIgnoreCase(loginTokenName)) continue;
            return cookie;
        }
        return null;
    }
}

