/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlesInstaller {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final OsgiConsoleClient osgiConsoleClient;
    public static final String ACTIVE_STATE = "active";

    public BundlesInstaller(OsgiConsoleClient cc) {
        this.osgiConsoleClient = cc;
    }

    public boolean isInstalled(File bundleFile) throws ClientException {
        String bundleSymbolicName = "";
        try {
            bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(bundleFile);
            this.log.debug("Checking if installed: " + bundleSymbolicName);
            this.osgiConsoleClient.getBundleState(bundleSymbolicName);
            this.log.debug("Already installed: " + bundleSymbolicName);
            return true;
        }
        catch (ClientException e) {
            this.log.debug("Not yet installed: " + bundleSymbolicName);
            return false;
        }
        catch (IOException e) {
            this.log.debug("Failed to retrieve bundle symbolic name from file. ", e);
            throw new ClientException("Failed to retrieve bundle symbolic name from file. ", e);
        }
    }

    public boolean isInstalledWithSameVersion(File bundleFile) throws ClientException, IOException {
        String versionInBundle;
        String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(bundleFile);
        String versionOnServer = this.osgiConsoleClient.getBundleVersion(bundleSymbolicName);
        if (versionOnServer.equals(versionInBundle = OsgiConsoleClient.getBundleVersionFromFile(bundleFile))) {
            return true;
        }
        this.log.warn("Installed bundle doesn't match: {}, versionOnServer={}, versionInBundle={}", bundleSymbolicName, versionOnServer, versionInBundle);
        return false;
    }

    public void installBundles(List<File> toInstall, boolean startBundles) throws ClientException, IOException {
        for (File f : toInstall) {
            String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(f);
            if (this.isInstalled(f)) {
                if (f.getName().contains("SNAPSHOT")) {
                    this.log.info("Reinstalling (due to SNAPSHOT version): {}", (Object)bundleSymbolicName);
                    this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                } else if (!this.isInstalledWithSameVersion(f)) {
                    this.log.info("Reinstalling (due to version mismatch): {}", (Object)bundleSymbolicName);
                    this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                } else {
                    this.log.info("Not reinstalling: {}", (Object)bundleSymbolicName);
                    continue;
                }
            }
            this.osgiConsoleClient.installBundle(f, startBundles);
            this.log.info("Installed: {}", (Object)bundleSymbolicName);
        }
        this.osgiConsoleClient.refreshPackages();
        this.log.info("{} additional bundles installed", (Object)toInstall.size());
    }

    public void uninstallBundles(List<File> toUninstall) throws ClientException, IOException {
        for (File f : toUninstall) {
            String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(f);
            if (this.isInstalled(f)) {
                this.log.info("Uninstalling bundle: {}", (Object)bundleSymbolicName);
                this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                continue;
            }
            this.log.info("Could not uninstall: {} as it never was installed", (Object)bundleSymbolicName);
        }
        this.osgiConsoleClient.refreshPackages();
        this.log.info("{} additional bundles uninstalled", (Object)toUninstall.size());
    }

    @Deprecated
    public boolean waitForBundlesInstalled(List<String> symbolicNames, int timeoutSeconds) throws ClientException, InterruptedException {
        this.log.info("Checking that the following bundles are installed (timeout {} seconds): {}", (Object)timeoutSeconds, (Object)symbolicNames);
        for (String symbolicName : symbolicNames) {
            boolean started = this.osgiConsoleClient.checkBundleInstalled(symbolicName, 500, 2 * timeoutSeconds);
            if (started) continue;
            return false;
        }
        return true;
    }

    public void waitBundlesInstalled(List<String> symbolicNames, long timeout) throws InterruptedException, TimeoutException {
        this.log.info("Checking that the following bundles are installed (timeout {} ms): {}", (Object)timeout, (Object)symbolicNames);
        long start = System.currentTimeMillis();
        for (String symbolicName : symbolicNames) {
            this.osgiConsoleClient.waitBundleInstalled(symbolicName, timeout, 500L);
            if (System.currentTimeMillis() <= start + timeout) continue;
            throw new TimeoutException("Waiting for bundles did not finish in " + timeout + " ms.");
        }
    }

    public void startAllBundles(final List<String> symbolicNames, int timeout) throws InterruptedException, TimeoutException {
        this.log.info("Starting bundles (timeout {} seconds): {}", (Object)timeout, (Object)symbolicNames);
        Polling p = new Polling(){

            @Override
            public Boolean call() throws Exception {
                boolean allActive = true;
                for (String bundle : symbolicNames) {
                    String state = BundlesInstaller.this.osgiConsoleClient.getBundleState(bundle);
                    if (state.equalsIgnoreCase(BundlesInstaller.ACTIVE_STATE)) continue;
                    BundlesInstaller.this.osgiConsoleClient.startBundle(bundle);
                    allActive = false;
                }
                return allActive;
            }
        };
        p.poll(timeout, 500L);
    }
}

