/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInstanceConfig
implements InstanceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiInstanceConfig.class);
    private static final long WAIT_TIMEOUT = 20000L;
    private final OsgiConsoleClient osgiClient;
    private final String configPID;
    private Map<String, Object> config;
    @Deprecated
    protected int waitCount = 20;

    public <T extends SlingClient> OsgiInstanceConfig(T client, String configPID) throws ClientException, InstanceConfigException, InterruptedException {
        this.osgiClient = ((AbstractSlingClient)client).adaptTo(OsgiConsoleClient.class);
        this.configPID = configPID;
        this.save();
    }

    @Override
    public InstanceConfig save() throws InstanceConfigException, InterruptedException {
        try {
            this.config = this.osgiClient.waitGetConfiguration(20000L, this.configPID, new int[0]);
            LOG.info("Saved OSGi config for {}. It is currently this: {}", (Object)this.configPID, (Object)this.config);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Error getting config", e);
        }
        catch (TimeoutException e) {
            throw new InstanceConfigException("Timeout of 20000 ms was reached while waiting for the configuration", e);
        }
        return this;
    }

    @Override
    public InstanceConfig restore() throws InstanceConfigException, InterruptedException {
        try {
            this.osgiClient.waitEditConfiguration(20000L, this.configPID, null, this.config, new int[0]);
            LOG.info("restored OSGi config for {}. It is now this: {}", (Object)this.configPID, (Object)this.config);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not edit OSGi configuration", e);
        }
        catch (TimeoutException e) {
            throw new InstanceConfigException("Timeout of 20000 ms was reached while waiting for the configuration", e);
        }
        return this;
    }
}

