/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class FormEntityBuilder {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private String encoding = "UTF-8";

    public static FormEntityBuilder create() {
        return new FormEntityBuilder();
    }

    FormEntityBuilder() {
    }

    public FormEntityBuilder addAllParameters(Map<String, String> parameters) {
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                this.addParameter(key, parameters.get(key));
            }
        }
        return this;
    }

    public FormEntityBuilder addAllParameters(List<NameValuePair> parameters) {
        if (parameters != null) {
            this.params.addAll(parameters);
        }
        return this;
    }

    public FormEntityBuilder addParameter(String name, String value) {
        this.params.add(new BasicNameValuePair(name, value));
        return this;
    }

    public FormEntityBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public UrlEncodedFormEntity build() {
        try {
            return new UrlEncodedFormEntity(this.params, this.encoding);
        }
        catch (UnsupportedEncodingException ue) {
            throw new Error("Unexpected UnsupportedEncodingException", ue);
        }
    }
}

