/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class URLParameterBuilder {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private List<NameValuePair> params = new ArrayList<NameValuePair>();
    private String encoding = "UTF-8";

    public static URLParameterBuilder create() {
        return new URLParameterBuilder();
    }

    URLParameterBuilder() {
    }

    public URLParameterBuilder add(String name, String value) {
        this.params.add(new BasicNameValuePair(name, value));
        return this;
    }

    public URLParameterBuilder add(NameValuePair pair) {
        this.params.add(pair);
        return this;
    }

    public URLParameterBuilder add(List<NameValuePair> list) {
        this.params.addAll(list);
        return this;
    }

    public URLParameterBuilder add(String name, String[] values) {
        for (String value : values) {
            this.add(name, value);
        }
        return this;
    }

    public URLParameterBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getURLParameters() {
        return URLEncodedUtils.format(this.params, this.encoding);
    }

    public List<NameValuePair> getList() {
        return this.params;
    }
}

