/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AuthenticationException;

public class ESAPIFilter
implements Filter {
    private final Logger logger = ESAPI.getLogger("ESAPIFilter");
    private static final String[] obfuscate = new String[]{"password"};

    public void init(FilterConfig filterConfig) {
        String path = filterConfig.getInitParameter("resourceDirectory");
        if (path != null) {
            ESAPI.securityConfiguration().setResourceDirectory(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        ESAPI.httpUtilities().setCurrentHTTP(request, response);
        try {
            try {
                ESAPI.authenticator().login(request, response);
            }
            catch (AuthenticationException e) {
                ESAPI.authenticator().logout();
                request.setAttribute("message", "Authentication failed");
                RequestDispatcher dispatcher = request.getRequestDispatcher("WEB-INF/login.jsp");
                dispatcher.forward(request, response);
                ESAPI.clearCurrent();
                return;
            }
            ESAPI.httpUtilities().logHTTPRequest(request, this.logger, Arrays.asList(obfuscate));
            if (!ESAPI.accessController().isAuthorizedForURL(request.getRequestURI())) {
                request.setAttribute("message", "Unauthorized");
                RequestDispatcher dispatcher = request.getRequestDispatcher("WEB-INF/index.jsp");
                dispatcher.forward(request, response);
                return;
            }
            chain.doFilter(request, response);
            ESAPI.httpUtilities().setContentType(response);
            ESAPI.httpUtilities().setNoCacheHeaders(response);
        }
        catch (Exception e) {
            this.logger.error(Logger.SECURITY_FAILURE, "Error in ESAPI security filter: " + e.getMessage(), e);
            request.setAttribute("message", e.getMessage());
        }
        finally {
            ESAPI.clearCurrent();
        }
    }

    public void destroy() {
    }
}

