/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.filters.SecurityWrapperRequest;
import org.owasp.esapi.filters.SecurityWrapperResponse;

public class SecurityWrapper
implements Filter {
    private final Logger logger = ESAPI.getLogger("SecurityWrapper");
    private String allowableResourcesRoot = "WEB-INF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        try {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            HttpServletResponse hresponse = (HttpServletResponse)response;
            SecurityWrapperRequest secureRequest = new SecurityWrapperRequest(hrequest);
            SecurityWrapperResponse secureResponse = new SecurityWrapperResponse(hresponse);
            secureRequest.setAllowableContentRoot(this.allowableResourcesRoot);
            ESAPI.httpUtilities().setCurrentHTTP(secureRequest, secureResponse);
            chain.doFilter(ESAPI.currentRequest(), ESAPI.currentResponse());
        }
        catch (Exception e) {
            this.logger.error(Logger.SECURITY_FAILURE, "Error in SecurityWrapper: " + e.getMessage(), e);
            request.setAttribute("message", e.getMessage());
        }
        finally {
            ESAPI.httpUtilities().clearCurrent();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.allowableResourcesRoot = StringUtilities.replaceNull(filterConfig.getInitParameter("allowableResourcesRoot"), this.allowableResourcesRoot);
    }
}

