/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.owasp.esapi.waf.internal.Parameter;

public class InterceptingHTTPServletRequest
extends HttpServletRequestWrapper {
    private Vector<Parameter> allParameters = new Vector();
    private Vector<String> allParameterNames = new Vector();
    private static int CHUNKED_BUFFER_SIZE = 1024;
    private boolean isMultipart = false;
    private RandomAccessFile requestBody;
    private RAFInputStream is;

    public ServletInputStream getInputStream() throws IOException {
        if (this.isMultipart) {
            return this.is;
        }
        return super.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
    }

    public InterceptingHTTPServletRequest(HttpServletRequest request) throws FileUploadException, IOException {
        super(request);
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = e.nextElement();
            this.allParameters.add(new Parameter(param, request.getParameter(param), false));
            this.allParameterNames.add(param);
        }
        this.isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (this.isMultipart) {
            this.requestBody = new RandomAccessFile(File.createTempFile("oew", "mpc"), "rw");
            byte[] buffer = new byte[CHUNKED_BUFFER_SIZE];
            long size = 0L;
            int len = 0;
            while (len != -1 && size <= Integer.MAX_VALUE) {
                len = request.getInputStream().read(buffer, 0, CHUNKED_BUFFER_SIZE);
                if (len == -1) continue;
                size += (long)len;
                this.requestBody.write(buffer, 0, len);
            }
            this.is = new RAFInputStream(this.requestBody);
            ServletFileUpload sfu = new ServletFileUpload();
            FileItemIterator iter = sfu.getItemIterator((HttpServletRequest)this);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                if (!item.isFormField()) continue;
                String value = Streams.asString((InputStream)stream);
                this.allParameters.add(new Parameter(name, value, true));
                this.allParameterNames.add(name);
            }
            this.requestBody.seek(0L);
        }
    }

    public String getDictionaryParameter(String s) {
        for (int i = 0; i < this.allParameters.size(); ++i) {
            Parameter p = this.allParameters.get(i);
            if (!p.getName().equals(s)) continue;
            return p.getValue();
        }
        return null;
    }

    public Enumeration getDictionaryParameterNames() {
        return this.allParameterNames.elements();
    }

    private class RAFInputStream
    extends ServletInputStream {
        RandomAccessFile raf;

        public RAFInputStream(RandomAccessFile raf) throws IOException {
            this.raf = raf;
            this.raf.seek(0L);
        }

        public int read() throws IOException {
            return this.raf.read();
        }

        public synchronized void reset() throws IOException {
            this.raf.seek(0L);
        }
    }
}

