/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.afrunt.jpa.powerdao;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import java.util.List;
import java.util.Map;

/**
 * @author Andrii Frunt
 */
public interface EntityManagerAdapter extends EntityManager, WithCollectionOperations {
    EntityManager getEntityManager();

    @Override
    Query createNativeQuery(String sql);

    @Override
    Query createNativeQuery(String sqlString, Class resultClass);

    @Override
    Query createNativeQuery(String sqlString, String resultSetMapping);

    @Override
    Query createQuery(String qlString);

    @Override
    <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery);

    @Override
    Query createQuery(CriteriaUpdate updateQuery);

    @Override
    Query createQuery(CriteriaDelete deleteQuery);

    @Override
    <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass);

    @Override
    Query createNamedQuery(String name);

    @Override
    <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass);

    @Override
    CriteriaBuilder getCriteriaBuilder();

    @Override
    <T> T find(Class<T> entityClass, Object primaryKey);

    @Override
    <T> T find(Class<T> entityClass, Object primaryKey,
               Map<String, Object> properties);

    @Override
    <T> T find(Class<T> entityClass, Object primaryKey,
               LockModeType lockMode);

    @Override
    <T> T find(Class<T> entityClass, Object primaryKey,
               LockModeType lockMode,
               Map<String, Object> properties);

    @Override
    <T> T merge(T entity);

    @Override
    void remove(Object entity);

    @Override
    Metamodel getMetamodel();

    @Override
    void persist(Object entity);

    @Override
    <T> T getReference(Class<T> entityClass, Object primaryKey);

    @Override
    void flush();

    @Override
    FlushModeType getFlushMode();

    @Override
    void setFlushMode(FlushModeType flushMode);

    @Override
    void lock(Object entity, LockModeType lockMode);

    @Override
    void lock(Object entity, LockModeType lockMode, Map<String, Object> properties);

    @Override
    void refresh(Object entity);

    @Override
    void refresh(Object entity, Map<String, Object> properties);

    @Override
    void refresh(Object entity, LockModeType lockMode);

    @Override
    void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties);

    @Override
    void clear();

    @Override
    void detach(Object entity);

    @Override
    boolean contains(Object entity);

    @Override
    LockModeType getLockMode(Object entity);

    @Override
    void setProperty(String propertyName, Object value);

    @Override
    Map<String, Object> getProperties();

    @Override
    StoredProcedureQuery createNamedStoredProcedureQuery(String name);

    @Override
    StoredProcedureQuery createStoredProcedureQuery(String procedureName);

    @Override
    StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class... resultClasses);

    @Override
    StoredProcedureQuery createStoredProcedureQuery(String procedureName, String... resultSetMappings);

    @Override
    void joinTransaction();

    @Override
    boolean isJoinedToTransaction();

    @Override
    <T> T unwrap(Class<T> cls);

    @Override
    Object getDelegate();

    @Override
    void close();

    @Override
    boolean isOpen();

    @Override
    EntityTransaction getTransaction();

    @Override
    EntityManagerFactory getEntityManagerFactory();

    @Override
    <T> EntityGraph<T> createEntityGraph(Class<T> rootType);

    @Override
    EntityGraph<?> createEntityGraph(String graphName);

    @Override
    EntityGraph<?> getEntityGraph(String graphName);

    @Override
    <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass);
}
