/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.afrunt.jpa.powerdao;

import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaQuery;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * @author Andrii Frunt
 */
public interface ExtendedApiDao extends EntityManagerAdapter, ExtendedQueryApiDao {
    <ET> Optional<ET> findById(Class<ET> entityClass, Object primaryKey);

    <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey,
                               Map<String, Object> properties);

    <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey,
                               LockModeType lockMode);

    <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey,
                               LockModeType lockMode,
                               Map<String, Object> properties);

    <ET> List<ET> findAll(Class<ET> entityClass);

    <ET> Stream<ET> findAllStream(Class<ET> entityClass);

    <ET> CriteriaQuery<ET> findAllQuery(Class<ET> entityClass);

    <ET> boolean exists(Class<ET> entityType, Object primaryKey);

    <ET> CriteriaQuery<Long> createCountQuery(Class<ET> entityType);

    <ET> long count(Class<ET> entityType);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> findByIds(Class<ET> entityType, Collection<KT> ids, int maxInSize);

    <ET, KT> List<ET> findByIds(Class<ET> entityType, Collection<KT> ids);

    <ET> Optional<ET> random(Class<ET> entityType);

    @SuppressWarnings("unchecked")
    <ET, KT> int deleteById(Class<ET> entityType, KT id);

    <ET, KT> int deleteByIds(Class<ET> entityType, Collection<KT> ids, int maxInSize);

    <ET, KT> int deleteByIds(Class<ET> entityType, Collection<KT> ids);

    long pageCount(long recordsCount, long perPage);

    <ET, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<KT> ids);

    @SuppressWarnings("unchecked")
    <ET, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<KT> ids, int partitionSize);

    <ET, VT, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<VT> objects, Function<VT, KT> idMapper);

    @SuppressWarnings("unchecked")
    <ET, VT, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<VT> objects, Function<VT, KT> idMapper, int partitionSize);
}
