/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.afrunt.jpa.powerdao;

import javax.persistence.LockModeType;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * @author Andrii Frunt
 */
public interface ExtendedEntityApiDao<ET, KT> extends EntityManagerAdapter, ExtendedQueryApiDao, ExtendedApiDao {
    int getDefaultInClauseLimit();

    long count();

    ET find(Object primaryKey);

    ET find(Object primaryKey,
            Map<String, Object> properties);

    ET find(Object primaryKey, LockModeType lockMode);

    ET find(Object primaryKey, LockModeType lockMode, Map<String, Object> properties);

    List<ET> findAll();

    Stream<ET> findAllStream();

    Optional<ET> findById(KT primaryKey);

    Optional<ET> findById(KT primaryKey, Map<String, Object> properties);

    Optional<ET> findById(KT primaryKey, LockModeType lockMode);

    Optional<ET> findById(KT primaryKey, LockModeType lockMode, Map<String, Object> properties);

    List<ET> findByIds(Collection<KT> ids, int maxInSize);

    List<ET> findByIds(Collection<KT> ids);

    Optional<ET> random();

    boolean exists(KT primaryKey);

    int deleteById(KT id);

    int deleteByIds(Collection<KT> ids);

    int deleteByIds(Collection<KT> ids, int maxInSize);

    Set<KT> findExistingEntityIdsIn(Collection<KT> ids);

    Set<KT> findExistingEntityIdsIn(Collection<KT> ids, int partitionSize);


    <VT> Set<KT> findExistingEntityIdsIn(Collection<VT> objects, Function<VT, KT> idMapper);

    @SuppressWarnings("unchecked")
    <VT> Set<KT> findExistingEntityIdsIn(Collection<VT> objects, Function<VT, KT> idMapper, int partitionSize);
}
