/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.afrunt.jpa.powerdao;

import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @author Andrii Frunt
 */
public interface ExtendedQueryApiDao extends EntityManagerAdapter {
    <ET> Optional<ET> queryResult(String jpql);

    <ET> Optional<ET> queryResult(String jpql, Map<String, Object> params);

    <ET> Optional<ET> queryResult(String jpql, List<Object> params);

    <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType);

    <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType, Map<String, Object> params);

    <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> Optional<ET> queryResult(Query query);

    <ET> Optional<ET> queryResult(Query query, Map<String, Object> params);

    <ET> Optional<ET> queryResult(Query query, List<Object> params);

    <ET> Optional<ET> queryResult(TypedQuery<ET> query, Map<String, Object> params);

    <ET> Optional<ET> queryResult(TypedQuery<ET> query, List<Object> params);

    <ET> Optional<ET> namedQueryResult(String queryName, Map<String, Object> params);

    <ET> Optional<ET> namedQueryResult(String queryName, List<Object> params);

    <ET> Optional<ET> namedQueryResult(String queryName, Class<ET> entityType, Map<String, Object> params);

    <ET> Optional<ET> namedQueryResult(String queryName, Class<ET> entityType, List<Object> params);

    <ET> Optional<ET> nativeQueryResult(String sql);

    <ET> Optional<ET> nativeQueryResult(String sql, Class<ET> entityType);

    <ET> Optional<ET> nativeQueryResult(String sql, List<Object> params);

    <ET> Optional<ET> nativeQueryResult(String sql, Class<ET> entityType, List<Object> params);

    <ET> Optional<ET> nativeQueryResult(String sql, String resultSetMapping);

    <ET> Optional<ET> nativeQueryResult(String sql, String resultSetMapping, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> List<ET> queryResultList(String jpql);

    <ET> List<ET> queryResultList(String jpql, Map<String, Object> params);

    <ET> List<ET> queryResultList(String jpql, List<Object> params);


    @SuppressWarnings("unchecked")
    <ET> List<ET> queryResultList(String jpql, Class<ET> entityType);

    <ET> List<ET> queryResultList(String jpql, Class<ET> entityType, Map<String, Object> params);

    <ET> List<ET> queryResultList(String jpql, Class<ET> entityType, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> List<ET> queryResultList(Query query);

    <ET> List<ET> queryResultList(TypedQuery<ET> query);

    <ET> List<ET> queryResultList(Query query, Map<String, Object> params);

    <ET> List<ET> queryResultList(Query query, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> List<ET> nativeQueryResultList(String sql);

    <ET> List<ET> nativeQueryResultList(String sql, String resultSetMapping);

    <ET> List<ET> nativeQueryResultList(String sql, String resultSetMapping, List<Object> params);

    <ET> List<ET> nativeQueryResultList(String sql, Class<ET> entityType);

    <ET> List<ET> nativeQueryResultList(String sql, List<Object> params);

    <ET> List<ET> nativeQueryResultList(String sql, Class<ET> entityType, List<Object> params);

    <ET> List<ET> namedQueryResultList(String queryName, Map<String, Object> params);

    <ET> List<ET> namedQueryResultList(String queryName, List<Object> params);

    <ET> List<ET> namedQueryResultList(String queryName);

    <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType);

    <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType, Map<String, Object> params);

    <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType, List<Object> params);

    <ET> Stream<ET> queryResultStream(String jpql);

    <ET> Stream<ET> queryResultStream(String jpql, Map<String, Object> params);

    <ET> Stream<ET> queryResultStream(String jpql, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> Stream<ET> queryResultStream(Query query);

    @SuppressWarnings("unchecked")
    <ET> Stream<ET> queryResultStream(Query query, Map<String, Object> params);

    <ET> Stream<ET> queryResultStream(Query query, List<Object> params);

    <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType);

    <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType, Map<String, Object> params);

    <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType);

    @SuppressWarnings("unchecked")
    <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType, Map<String, Object> params);

    <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType, List<Object> params);

    <ET> Stream<ET> namedQueryResultStream(String name);

    <ET> Stream<ET> namedQueryResultStream(String name, Map<String, Object> params);

    <ET> Stream<ET> namedQueryResultStream(String name, List<Object> params);

    <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType);

    <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType, Map<String, Object> params);

    <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType, List<Object> params);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> partitionsToNamedQueryResultList(String name, Class<ET> entityType, Collection<KT> params, int partitionSize);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> partitionsToNamedQueryResultList(String name, Collection<KT> params, int partitionSize);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> partitionsToQueryResultList(Query query, Class<ET> entityType, Collection<KT> params, int partitionSize);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> partitionsToQueryResultList(String jpql, Class<ET> entityType, Collection<KT> params, int partitionSize);

    @SuppressWarnings("unchecked")
    <ET, KT> List<ET> partitionsToQueryResultList(String jpql, Collection<KT> params, int partitionSize);

    Query parameterizedQuery(Query query, Map<String, Object> params);

    Query parameterizedQuery(Query query, List<Object> params);

    Query passSingleParameter(Query query, Object parameter);

    <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql);

    <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql, Map<String, Object> params);

    <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql, List<Object> params);

    <ET> List<ET> queryPage(long pageIndex, long perPage, Query query);

    <ET> List<ET> queryPage(long pageIndex, long perPage, Query query, Map<String, Object> params);

    <ET> List<ET> queryPage(long pageIndex, long perPage, Query query, List<Object> params);

    <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName);

    <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName, Map<String, Object> params);

    <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName, List<Object> params);
}
