/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.afrunt.jpa.powerdao;

import javax.persistence.EntityManager;

/**
 * @author Andrii Frunt
 */
public class SimpleDao extends AbstractExtendedApiDao {
    private EntityManager em;

    /**
     * In this case you should override the getEntityManager() method to provide the appropriate EntityManager for
     * your context.
     */
    public SimpleDao() {
    }

    public SimpleDao(EntityManager em) {
        if (em == null) {
            throw new NullPointerException("EntityManager cannot be null");
        }
        this.em = em;
    }

    public static SimpleDao instance(EntityManager em) {
        return new SimpleDao(em);
    }

    @Override
    public EntityManager getEntityManager() {
        if (em == null) {
            throw new IllegalStateException("EntityManager cannot be null");
        }
        return em;
    }

    public SimpleDao setEm(EntityManager em) {
        this.em = em;
        return this;
    }
}
