/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.jpa.powerdao;

import com.afrunt.jpa.powerdao.AbstractExtendedQueryApiDao;
import com.afrunt.jpa.powerdao.ExtendedApiDao;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public abstract class AbstractExtendedApiDao
extends AbstractExtendedQueryApiDao
implements ExtendedApiDao {
    @Override
    public <ET> Optional<ET> findById(Class<ET> entityClass, Object primaryKey) {
        return Optional.ofNullable(this.find(entityClass, primaryKey));
    }

    @Override
    public <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey, Map<String, Object> properties) {
        return Optional.ofNullable(this.find(entityType, primaryKey, properties));
    }

    @Override
    public <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey, LockModeType lockMode) {
        return Optional.ofNullable(this.find(entityType, primaryKey, lockMode));
    }

    @Override
    public <ET> Optional<ET> findById(Class<ET> entityType, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return Optional.ofNullable(this.find(entityType, primaryKey, lockMode, properties));
    }

    @Override
    public <ET> List<ET> findAll(Class<ET> entityClass) {
        return this.createQuery(this.findAllQuery(entityClass)).getResultList();
    }

    @Override
    public <ET> Stream<ET> findAllStream(Class<ET> entityClass) {
        return this.queryResultStream((Query)this.createQuery(this.findAllQuery(entityClass)));
    }

    @Override
    public <ET> CriteriaQuery<ET> findAllQuery(Class<ET> entityClass) {
        CriteriaBuilder cb = this.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(entityClass);
        query.from(entityClass);
        return query;
    }

    @Override
    public <ET> boolean exists(Class<ET> entityType, Object primaryKey) {
        String idFieldName = this.getIdFieldName(entityType);
        CriteriaBuilder cb = this.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root from = query.from(entityType);
        query.select((Selection)cb.count((Expression)from));
        query.where((Expression)cb.equal((Expression)from.get(idFieldName), primaryKey));
        return (Long)this.createQuery(query).getSingleResult() == 1L;
    }

    @Override
    public <ET> CriteriaQuery<Long> createCountQuery(Class<ET> entityType) {
        CriteriaBuilder cb = this.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        query.select((Selection)cb.count((Expression)query.from(entityType)));
        return query;
    }

    @Override
    public <ET> long count(Class<ET> entityType) {
        return (Long)this.createQuery(this.createCountQuery(entityType)).getSingleResult();
    }

    @Override
    public <ET, KT> List<ET> findByIds(Class<ET> entityType, Collection<KT> ids, int maxInSize) {
        return this.partitionsTo(ids, maxInSize, p -> this.findByIds(entityType, (Collection)p));
    }

    @Override
    public <ET, KT> List<ET> findByIds(Class<ET> entityType, Collection<KT> ids) {
        CriteriaBuilder cb = this.getCriteriaBuilder();
        CriteriaQuery find = cb.createQuery(entityType);
        Root from = find.from(entityType);
        find.where((Expression)from.get(this.getIdFieldName(entityType)).in(ids));
        TypedQuery query = this.createQuery(find);
        return this.queryResultList(query);
    }

    @Override
    public <ET, KT> int deleteById(Class<ET> entityType, KT id) {
        return this.deleteByIds(entityType, this.listOf(new Object[]{id}));
    }

    @Override
    public <ET, KT> int deleteByIds(Class<ET> entityType, Collection<KT> ids, int maxInSize) {
        return this.partitions(ids, maxInSize).stream().map(p -> this.deleteByIds(entityType, ids)).mapToInt(c -> c).sum();
    }

    @Override
    public <ET, KT> int deleteByIds(Class<ET> entityType, Collection<KT> ids) {
        CriteriaBuilder cb = this.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(entityType);
        Root from = delete.from(entityType);
        delete.where((Expression)from.get(this.getIdFieldName(entityType)).in(ids));
        return this.createQuery(delete).executeUpdate();
    }

    @Override
    public long pageCount(long recordsCount, long perPage) {
        return recordsCount / perPage + (long)(recordsCount % perPage == 0L ? 0 : 1);
    }

    @Override
    public <ET, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<KT> ids) {
        return this.findExistingEntityIdsIn(entityType, ids, 1000);
    }

    @Override
    public <ET, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<KT> ids, int partitionSize) {
        String idFieldName = this.getIdFieldName(entityType);
        String query = "SELECT e." + idFieldName + " FROM " + entityType.getSimpleName() + " e WHERE e." + idFieldName + " IN ?1";
        return new HashSet(this.partitionsToQueryResultList(query, this.getEntityIdType(entityType), ids, partitionSize));
    }

    @Override
    public <ET, VT, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<VT> objects, Function<VT, KT> idMapper) {
        return this.findExistingEntityIdsIn(entityType, objects.stream().map(idMapper).collect(Collectors.toSet()));
    }

    @Override
    public <ET, VT, KT> Set<KT> findExistingEntityIdsIn(Class<ET> entityType, Collection<VT> objects, Function<VT, KT> idMapper, int partitionSize) {
        return this.findExistingEntityIdsIn(entityType, objects.stream().map(idMapper).collect(Collectors.toSet()), partitionSize);
    }

    @Override
    public <ET> Optional<ET> random(Class<ET> entityType) {
        long total = this.count(entityType);
        if (total == 0L) {
            return Optional.empty();
        }
        long number = ThreadLocalRandom.current().nextLong(0L, total);
        List entities = this.queryPage(number, 1L, "SELECT e FROM " + entityType.getSimpleName() + " e");
        if (!entities.isEmpty()) {
            return Optional.of(entities.get(0));
        }
        return Optional.empty();
    }
}

