/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.jpa.powerdao;

import com.afrunt.jpa.powerdao.AbstractEntityManagerAdapter;
import com.afrunt.jpa.powerdao.ExtendedQueryApiDao;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public abstract class AbstractExtendedQueryApiDao
extends AbstractEntityManagerAdapter
implements ExtendedQueryApiDao {
    @Override
    public <ET> Optional<ET> queryResult(String jpql) {
        return this.queryResult(this.createQuery(jpql));
    }

    @Override
    public <ET> Optional<ET> queryResult(String jpql, Map<String, Object> params) {
        return this.queryResult(this.createQuery(jpql), params);
    }

    @Override
    public <ET> Optional<ET> queryResult(String jpql, List<Object> params) {
        return this.queryResult(this.createQuery(jpql), params);
    }

    @Override
    public <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType) {
        return this.queryResult((Query)this.createQuery(jpql, entityType));
    }

    @Override
    public <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResult(this.createQuery(jpql, entityType), params);
    }

    @Override
    public <ET> Optional<ET> queryResult(String jpql, Class<ET> entityType, List<Object> params) {
        return this.queryResult(this.createQuery(jpql, entityType), params);
    }

    @Override
    public <ET> Optional<ET> queryResult(Query query) {
        try {
            return Optional.ofNullable(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    @Override
    public <ET> Optional<ET> queryResult(Query query, Map<String, Object> params) {
        return this.queryResult(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> Optional<ET> queryResult(Query query, List<Object> params) {
        return this.queryResult(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> Optional<ET> queryResult(TypedQuery<ET> query, Map<String, Object> params) {
        return this.queryResult(this.parameterizedQuery((Query)query, params));
    }

    @Override
    public <ET> Optional<ET> queryResult(TypedQuery<ET> query, List<Object> params) {
        return this.queryResult(this.parameterizedQuery((Query)query, params));
    }

    @Override
    public <ET> Optional<ET> namedQueryResult(String queryName, Map<String, Object> params) {
        return this.queryResult(this.createNamedQuery(queryName), params);
    }

    @Override
    public <ET> Optional<ET> namedQueryResult(String queryName, List<Object> params) {
        return this.queryResult(this.createNamedQuery(queryName), params);
    }

    @Override
    public <ET> Optional<ET> namedQueryResult(String queryName, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResult(this.createNamedQuery(queryName, entityType), params);
    }

    @Override
    public <ET> Optional<ET> namedQueryResult(String queryName, Class<ET> entityType, List<Object> params) {
        return this.queryResult(this.createNamedQuery(queryName, entityType), params);
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql) {
        return this.queryResult(this.createNativeQuery(sql));
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql, Class<ET> entityType) {
        return this.queryResult(this.createNativeQuery(sql, entityType));
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql, List<Object> params) {
        return this.queryResult(this.parameterizedQuery(this.createNativeQuery(sql), params));
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql, Class<ET> entityType, List<Object> params) {
        return this.queryResult(this.parameterizedQuery(this.createNativeQuery(sql, entityType), params));
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql, String resultSetMapping) {
        return this.queryResult(this.createNativeQuery(sql, resultSetMapping));
    }

    @Override
    public <ET> Optional<ET> nativeQueryResult(String sql, String resultSetMapping, List<Object> params) {
        return this.queryResult(this.parameterizedQuery(this.createNativeQuery(sql, resultSetMapping), params));
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql) {
        return this.queryResultList(this.createQuery(jpql));
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql, Map<String, Object> params) {
        return this.queryResultList(this.createQuery(jpql), params);
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql, List<Object> params) {
        return this.queryResultList(this.createQuery(jpql), params);
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql, Class<ET> entityType) {
        return this.queryResultList(this.createQuery(jpql, entityType));
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResultList(this.parameterizedQuery((Query)this.createQuery(jpql, entityType), params));
    }

    @Override
    public <ET> List<ET> queryResultList(String jpql, Class<ET> entityType, List<Object> params) {
        return this.queryResultList(this.parameterizedQuery((Query)this.createQuery(jpql, entityType), params));
    }

    @Override
    public <ET> List<ET> queryResultList(Query query) {
        return query.getResultList();
    }

    @Override
    public <ET> List<ET> queryResultList(TypedQuery<ET> query) {
        return query.getResultList();
    }

    @Override
    public <ET> List<ET> queryResultList(Query query, Map<String, Object> params) {
        return this.queryResultList(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> List<ET> queryResultList(Query query, List<Object> params) {
        return this.queryResultList(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql) {
        return this.queryResultList(this.createNativeQuery(sql));
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql, String resultSetMapping) {
        return this.queryResultList(this.createNativeQuery(sql, resultSetMapping));
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql, String resultSetMapping, List<Object> params) {
        return this.queryResultList(this.parameterizedQuery(this.createNativeQuery(sql, resultSetMapping), params));
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql, Class<ET> entityType) {
        return this.queryResultList(this.createNativeQuery(sql, entityType));
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql, List<Object> params) {
        return this.queryResultList(this.createNativeQuery(sql), params);
    }

    @Override
    public <ET> List<ET> nativeQueryResultList(String sql, Class<ET> entityType, List<Object> params) {
        return this.queryResultList(this.createNativeQuery(sql, entityType), params);
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName, Map<String, Object> params) {
        return this.queryResultList(this.createNamedQuery(queryName), params);
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName, List<Object> params) {
        return this.queryResultList(this.createNamedQuery(queryName), params);
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName) {
        return this.queryResultList(this.createNamedQuery(queryName));
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType) {
        return this.queryResultList(this.createNamedQuery(queryName, entityType));
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResultList((Query)this.createNamedQuery(queryName, entityType), params);
    }

    @Override
    public <ET> List<ET> namedQueryResultList(String queryName, Class<ET> entityType, List<Object> params) {
        return this.queryResultList((Query)this.createNamedQuery(queryName, entityType), params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql) {
        return this.queryResultStream(this.createQuery(jpql));
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql, Map<String, Object> params) {
        return this.queryResultStream(this.createQuery(jpql), params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql, List<Object> params) {
        return this.queryResultStream(this.createQuery(jpql), params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query) {
        return query.getResultList().stream();
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query, Map<String, Object> params) {
        return this.queryResultStream(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query, List<Object> params) {
        return this.queryResultStream(this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType) {
        return this.queryResultStream((Query)this.createQuery(jpql, entityType));
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResultStream((Query)this.createQuery(jpql, entityType), params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(String jpql, Class<ET> entityType, List<Object> params) {
        return this.queryResultStream((Query)this.createQuery(jpql, entityType), params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType) {
        return this.queryResultStream(query);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResultStream(query, params);
    }

    @Override
    public <ET> Stream<ET> queryResultStream(Query query, Class<ET> entityType, List<Object> params) {
        return this.queryResultStream(query, params);
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name) {
        return this.queryResultStream(this.createNamedQuery(name));
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name, Map<String, Object> params) {
        return this.queryResultStream(this.createNamedQuery(name), params);
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name, List<Object> params) {
        return this.queryResultStream(this.createNamedQuery(name), params);
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType) {
        return this.queryResultStream(this.createNamedQuery(name), entityType);
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType, Map<String, Object> params) {
        return this.queryResultStream(this.createNamedQuery(name), entityType, params);
    }

    @Override
    public <ET> Stream<ET> namedQueryResultStream(String name, Class<ET> entityType, List<Object> params) {
        return this.queryResultStream(this.createNamedQuery(name), entityType, params);
    }

    @Override
    public <ET, KT> List<ET> partitionsToNamedQueryResultList(String name, Class<ET> entityType, Collection<KT> params, int partitionSize) {
        return this.partitionsTo(params, partitionSize, p -> this.namedQueryResultList(name, entityType, Collections.singletonList(p)));
    }

    @Override
    public <ET, KT> List<ET> partitionsToNamedQueryResultList(String name, Collection<KT> params, int partitionSize) {
        return this.partitionsTo(params, partitionSize, p -> this.namedQueryResultList(name, Collections.singletonList(p)));
    }

    @Override
    public <ET, KT> List<ET> partitionsToQueryResultList(Query query, Class<ET> entityType, Collection<KT> params, int partitionSize) {
        return this.partitionsTo(params, partitionSize, p -> this.queryResultList(this.passSingleParameter(query, p)));
    }

    @Override
    public <ET, KT> List<ET> partitionsToQueryResultList(String jpql, Class<ET> entityType, Collection<KT> params, int partitionSize) {
        return this.partitionsToQueryResultList(this.createQuery(jpql), entityType, params, partitionSize);
    }

    @Override
    public <ET, KT> List<ET> partitionsToQueryResultList(String jpql, Collection<KT> params, int partitionSize) {
        Query query = this.createQuery(jpql);
        return this.partitionsTo(params, partitionSize, p -> this.queryResultList(this.passSingleParameter(query, p)));
    }

    @Override
    public Query parameterizedQuery(Query query, Map<String, Object> params) {
        params.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query;
    }

    @Override
    public Query parameterizedQuery(Query query, List<Object> params) {
        IntStream.range(0, params.size()).boxed().forEach(i -> query.setParameter(i + 1, params.get((int)i)));
        return query;
    }

    @Override
    public Query passSingleParameter(Query query, Object parameter) {
        Set parameters = query.getParameters();
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Query should have only one parameter. Actual count is " + parameters.size());
        }
        if (((Parameter)parameters.iterator().next()).getName() != null) {
            query.setParameter(((Parameter)parameters.iterator().next()).getName(), parameter);
        } else {
            query.setParameter(1, parameter);
        }
        return query;
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql) {
        return this.queryPage(pageIndex, perPage, this.createQuery(jpql));
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql, Map<String, Object> params) {
        return this.queryPage(pageIndex, perPage, this.createQuery(jpql), params);
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, String jpql, List<Object> params) {
        return this.queryPage(pageIndex, perPage, this.createQuery(jpql), params);
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, Query query) {
        int firstResult = (int)(pageIndex * perPage);
        query.setFirstResult(firstResult).setMaxResults((int)perPage);
        return this.queryResultList(query);
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, Query query, Map<String, Object> params) {
        return this.queryPage(pageIndex, perPage, this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> List<ET> queryPage(long pageIndex, long perPage, Query query, List<Object> params) {
        return this.queryPage(pageIndex, perPage, this.parameterizedQuery(query, params));
    }

    @Override
    public <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName) {
        return this.queryPage(pageIndex, perPage, this.createNamedQuery(queryName));
    }

    @Override
    public <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName, Map<String, Object> params) {
        return this.queryPage(pageIndex, perPage, this.parameterizedQuery(this.createNamedQuery(queryName), params));
    }

    @Override
    public <ET> List<ET> namedQueryPage(long pageIndex, long perPage, String queryName, List<Object> params) {
        return this.queryPage(pageIndex, perPage, this.parameterizedQuery(this.createNamedQuery(queryName), params));
    }
}

