/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.jpa.powerdao;

import com.afrunt.jpa.powerdao.ExtendedEntityApiDao;
import com.afrunt.jpa.powerdao.SimpleDao;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;

public abstract class PowerDao<ET, KT>
extends SimpleDao
implements ExtendedEntityApiDao<ET, KT> {
    private Class<ET> entityType;
    private Class<KT> idType;

    public PowerDao() {
    }

    public PowerDao(EntityManager em) {
        super(em);
    }

    public static <AET, AKT> PowerDao<AET, AKT> instance(Class<AET> actualEntityType, Class<AKT> actualIdType, EntityManager em) {
        PowerDao powerDAO = new PowerDao<AET, AKT>(em){};
        powerDAO.cacheEntityType(actualEntityType);
        powerDAO.cacheIdType(actualIdType);
        return powerDAO;
    }

    @Override
    public int getDefaultInClauseLimit() {
        return 1000;
    }

    @Override
    public long count() {
        return this.count(this.getEntityType());
    }

    @Override
    public ET find(Object primaryKey) {
        return this.find(this.getEntityType(), primaryKey);
    }

    @Override
    public ET find(Object primaryKey, Map<String, Object> properties) {
        return this.find(this.getEntityType(), primaryKey, properties);
    }

    @Override
    public ET find(Object primaryKey, LockModeType lockMode) {
        return this.find(this.getEntityType(), primaryKey, lockMode);
    }

    @Override
    public ET find(Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return this.find(this.getEntityType(), primaryKey, lockMode, properties);
    }

    @Override
    public List<ET> findAll() {
        return this.findAll(this.getEntityType());
    }

    @Override
    public Stream<ET> findAllStream() {
        return this.findAllStream(this.getEntityType());
    }

    @Override
    public Optional<ET> findById(KT primaryKey) {
        return this.findById(this.getEntityType(), primaryKey);
    }

    @Override
    public Optional<ET> findById(KT primaryKey, Map<String, Object> properties) {
        return this.findById(this.getEntityType(), primaryKey, properties);
    }

    @Override
    public Optional<ET> findById(KT primaryKey, LockModeType lockMode) {
        return this.findById(this.getEntityType(), primaryKey, lockMode);
    }

    @Override
    public Optional<ET> findById(KT primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return this.findById(this.getEntityType(), primaryKey, lockMode, properties);
    }

    @Override
    public List<ET> findByIds(Collection<KT> ids, int maxInSize) {
        return this.findByIds(this.getEntityType(), ids, maxInSize);
    }

    @Override
    public List<ET> findByIds(Collection<KT> ids) {
        return this.findByIds(ids, this.getDefaultInClauseLimit());
    }

    @Override
    public boolean exists(KT primaryKey) {
        return this.exists(this.getEntityType(), primaryKey);
    }

    @Override
    public int deleteById(KT id) {
        return this.deleteById(this.getEntityType(), id);
    }

    @Override
    public int deleteByIds(Collection<KT> ids) {
        return this.deleteByIds(this.getEntityType(), ids, this.getDefaultInClauseLimit());
    }

    @Override
    public int deleteByIds(Collection<KT> ids, int maxInSize) {
        return this.deleteByIds(this.getEntityType(), ids, maxInSize);
    }

    @Override
    public Set<KT> findExistingEntityIdsIn(Collection<KT> ids) {
        return this.findExistingEntityIdsIn(this.entityType, ids);
    }

    @Override
    public Set<KT> findExistingEntityIdsIn(Collection<KT> ids, int partitionSize) {
        return this.findExistingEntityIdsIn(this.entityType, ids, partitionSize);
    }

    @Override
    public <VT> Set<KT> findExistingEntityIdsIn(Collection<VT> objects, Function<VT, KT> idMapper) {
        return this.findExistingEntityIdsIn(this.entityType, objects, idMapper);
    }

    @Override
    public <VT> Set<KT> findExistingEntityIdsIn(Collection<VT> objects, Function<VT, KT> idMapper, int partitionSize) {
        return this.findExistingEntityIdsIn(this.entityType, objects, idMapper, partitionSize);
    }

    protected Class<ET> getCachedEntityType() {
        return this.entityType;
    }

    protected Class<KT> getCachedIdType() {
        return this.idType;
    }

    protected Class<ET> cacheEntityType(Class<ET> entityType) {
        this.entityType = entityType;
        return this.entityType;
    }

    protected Class<KT> cacheIdType(Class<KT> idType) {
        this.idType = idType;
        return this.idType;
    }

    protected Class<ET> getEntityType() {
        Class<ET> cachedEntityType = this.getCachedEntityType();
        if (cachedEntityType != null) {
            return cachedEntityType;
        }
        ParameterizedType genericSuperclass = this.getCorrectGenericSuperclass();
        return this.cacheEntityType((Class)genericSuperclass.getActualTypeArguments()[0]);
    }

    protected Class<KT> getIdType() {
        Class<KT> cachedIdType = this.getCachedIdType();
        if (cachedIdType != null) {
            return cachedIdType;
        }
        ParameterizedType genericSuperclass = this.getCorrectGenericSuperclass();
        return this.cacheIdType((Class)genericSuperclass.getActualTypeArguments()[1]);
    }

    private boolean isCorrectGenericSuperType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        return actualTypeArguments.length == this.getNumberOfParameters() && actualTypeArguments[0] instanceof Class && ((Class)actualTypeArguments[0]).isAnnotationPresent(Entity.class);
    }

    protected int getNumberOfParameters() {
        return 2;
    }

    protected ParameterizedType getCorrectGenericSuperclass() {
        return this.getCorrectGenericSuperclass(this.getClass());
    }

    private ParameterizedType getCorrectGenericSuperclass(Class<? extends PowerDao> type) {
        Type genericSuperclass = type.getGenericSuperclass();
        List<Object> types = new ArrayList<Type>();
        types.add(type);
        types.add(genericSuperclass);
        types.addAll(Arrays.asList(type.getGenericInterfaces()));
        types = types.stream().filter(this::isCorrectGenericSuperType).collect(Collectors.toList());
        if (types.isEmpty() && PowerDao.class.isAssignableFrom(type.getSuperclass())) {
            return this.getCorrectGenericSuperclass(type.getSuperclass());
        }
        if (types.size() > 1) {
            throw new RuntimeException("Cannot infer generic supertype");
        }
        return (ParameterizedType)types.iterator().next();
    }

    @Override
    public Optional<ET> random() {
        return this.random(this.getEntityType());
    }
}

