/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.jpa.powerdao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface WithCollectionOperations {
    default public <KT> List<List<KT>> partitions(Collection<KT> sourceIds, int partitionSize) {
        if (sourceIds == null || sourceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList ids = new ArrayList(sourceIds);
        int idCount = ids.size();
        if (idCount <= partitionSize) {
            return Collections.singletonList(ids);
        }
        int numberOfPartitions = idCount / partitionSize + (idCount % partitionSize == 0 ? 0 : 1);
        return IntStream.range(0, numberOfPartitions).boxed().map(i -> ids.subList(i * partitionSize, i * partitionSize + partitionSize >= idCount ? idCount : i * partitionSize + partitionSize)).collect(Collectors.toList());
    }

    default public <KT> Stream<List<KT>> partitionsStream(Collection<KT> sourceIds, int partitionSize) {
        return this.partitions(sourceIds, partitionSize).stream();
    }

    default public <KT, ET> List<ET> partitionsTo(Collection<KT> sourceIds, int partitionSize, Function<List<KT>, List<ET>> mapper) {
        return this.mapPartitions(this.partitionsStream(sourceIds, partitionSize), mapper);
    }

    default public <KT, ET> List<ET> mapPartitions(List<List<KT>> partitions, Function<List<KT>, List<ET>> mapper) {
        return this.mapPartitions(partitions.stream(), mapper);
    }

    default public <KT, ET> List<ET> mapPartitions(Stream<List<KT>> partitions, Function<List<KT>, List<ET>> mapper) {
        return partitions.map(mapper).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public <KT> List<KT> listOf(KT ... objs) {
        return Arrays.asList(objs);
    }

    default public <K, V> Map<K, V> mapOf(Object ... kvs) {
        if (kvs == null || kvs.length == 0) {
            return new HashMap();
        }
        if (kvs.length % 2 != 0) {
            throw new IllegalArgumentException("Each key should have the value");
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            result.put(kvs[i], kvs[i + 1]);
        }
        return result;
    }

    default public <K, V> Map<K, V> emptyMap() {
        return this.mapOf(new Object[0]);
    }

    default public List<Integer> range(int from, int to) {
        return IntStream.range(from, to).boxed().collect(Collectors.toList());
    }

    default public List<Long> range(long from, long to) {
        return LongStream.range(from, to).boxed().collect(Collectors.toList());
    }

    default public List<Object> rawRange(int from, int to) {
        return new ArrayList<Object>(this.range(from, to));
    }

    default public List<Object> rawRange(long from, long to) {
        return new ArrayList<Object>(this.range(from, to));
    }
}

