/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableIntIntMap;
import com.almworks.integers.IntCollections;
import com.almworks.integers.IntFailFastIterator;
import com.almworks.integers.IntIntFailFastIterator;
import com.almworks.integers.IntIntIterable;
import com.almworks.integers.IntIntIterator;
import com.almworks.integers.IntIntIterators;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntSizedIterable;
import com.almworks.integers.wrappers.IntHppcWrappers;
import com.almworks.integers.wrappers.IntIntHppcWrappers;
import com.carrotsearch.hppc.IntIntOpenHashMap;

public class IntIntHppcOpenHashMap
extends AbstractWritableIntIntMap {
    protected final IntIntOpenHashMap myMap;

    public IntIntHppcOpenHashMap() {
        this.myMap = new IntIntOpenHashMap();
    }

    public IntIntHppcOpenHashMap(int initicalCapacity) {
        this.myMap = new IntIntOpenHashMap(initicalCapacity);
    }

    public IntIntHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new IntIntOpenHashMap(initialCapacity, loadFactor);
    }

    public static IntIntHppcOpenHashMap createFrom(IntIterable keys, IntIterable values) {
        int valuesSize;
        int keysSize = keys instanceof IntSizedIterable ? ((IntSizedIterable)keys).size() : 0;
        if (keysSize * (valuesSize = IntCollections.sizeOfIterable((IntIterable)values, (int)0)) != 0) {
            if (keysSize != valuesSize) {
                throw new IllegalArgumentException("keys.size() != values.size()");
            }
        } else {
            keysSize = Math.max(keysSize, valuesSize);
        }
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)keysSize / loadFactor) + 1;
        IntIntHppcOpenHashMap map = new IntIntHppcOpenHashMap(initialCapacity);
        IntIterator keysIt = keys.iterator();
        IntIterator valuesIt = values.iterator();
        map.putAll((IntIntIterable)IntIntIterators.pair((IntIterable)keysIt, (IntIterable)valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static IntIntHppcOpenHashMap createFrom(int[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        IntIntHppcOpenHashMap map = new IntIntHppcOpenHashMap(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static IntIntHppcOpenHashMap createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new IntIntHppcOpenHashMap(initialCapacity, loadFactor);
    }

    public static IntIntHppcOpenHashMap createForAdd(int count) {
        return IntIntHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    public IntIntIterator iterator() {
        return new IntIntFailFastIterator((IntIntIterator)IntIntHppcWrappers.cursorToIntIntIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return IntIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public IntIterator keysIterator() {
        return new IntFailFastIterator(IntHppcWrappers.cursorToIntIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return IntIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public IntIterator valuesIterator() {
        return new IntFailFastIterator(IntHppcWrappers.cursorToIntIterator(this.myMap.values().iterator())){

            protected int getCurrentModCount() {
                return IntIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public int get(int key) {
        return this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected int putImpl(int key, int value) {
        return this.myMap.put(key, value);
    }

    public int putOrAdd(int key, int putValue, int additionValue) {
        this.modified();
        return this.myMap.putOrAdd(key, putValue, additionValue);
    }

    public int addTo(int key, int additionValue) {
        this.modified();
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public int lget() {
        return this.myMap.lget();
    }

    public int lset(int key) {
        return this.myMap.lset(key);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected int removeImpl(int key) {
        return this.myMap.remove(key);
    }

    public boolean remove(int key, int value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

