/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableIntLongMap;
import com.almworks.integers.IntFailFastIterator;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntLongFailFastIterator;
import com.almworks.integers.IntLongIterable;
import com.almworks.integers.IntLongIterator;
import com.almworks.integers.IntLongIterators;
import com.almworks.integers.IntSizedIterable;
import com.almworks.integers.LongCollections;
import com.almworks.integers.LongFailFastIterator;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.wrappers.IntHppcWrappers;
import com.almworks.integers.wrappers.IntLongHppcWrappers;
import com.almworks.integers.wrappers.LongHppcWrappers;
import com.carrotsearch.hppc.IntLongOpenHashMap;

public class IntLongHppcOpenHashMap
extends AbstractWritableIntLongMap {
    protected final IntLongOpenHashMap myMap;

    public IntLongHppcOpenHashMap() {
        this.myMap = new IntLongOpenHashMap();
    }

    public IntLongHppcOpenHashMap(int initicalCapacity) {
        this.myMap = new IntLongOpenHashMap(initicalCapacity);
    }

    public IntLongHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new IntLongOpenHashMap(initialCapacity, loadFactor);
    }

    public static IntLongHppcOpenHashMap createFrom(IntIterable keys, LongIterable values) {
        int valuesSize;
        int keysSize = keys instanceof IntSizedIterable ? ((IntSizedIterable)keys).size() : 0;
        if (keysSize * (valuesSize = LongCollections.sizeOfIterable((LongIterable)values, (int)0)) != 0) {
            if (keysSize != valuesSize) {
                throw new IllegalArgumentException("keys.size() != values.size()");
            }
        } else {
            keysSize = Math.max(keysSize, valuesSize);
        }
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)keysSize / loadFactor) + 1;
        IntLongHppcOpenHashMap map = new IntLongHppcOpenHashMap(initialCapacity);
        IntIterator keysIt = keys.iterator();
        LongIterator valuesIt = values.iterator();
        map.putAll((IntLongIterable)IntLongIterators.pair((IntIterable)keysIt, (LongIterable)valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static IntLongHppcOpenHashMap createFrom(int[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        IntLongHppcOpenHashMap map = new IntLongHppcOpenHashMap(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static IntLongHppcOpenHashMap createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new IntLongHppcOpenHashMap(initialCapacity, loadFactor);
    }

    public static IntLongHppcOpenHashMap createForAdd(int count) {
        return IntLongHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    public IntLongIterator iterator() {
        return new IntLongFailFastIterator((IntLongIterator)IntLongHppcWrappers.cursorToIntLongIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return IntLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public IntIterator keysIterator() {
        return new IntFailFastIterator(IntHppcWrappers.cursorToIntIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return IntLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public LongIterator valuesIterator() {
        return new LongFailFastIterator(LongHppcWrappers.cursorToLongIterator(this.myMap.values().iterator())){

            protected int getCurrentModCount() {
                return IntLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public long get(int key) {
        return this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected long putImpl(int key, long value) {
        return this.myMap.put(key, value);
    }

    public long putOrAdd(int key, long putValue, long additionValue) {
        this.modified();
        return this.myMap.putOrAdd(key, putValue, additionValue);
    }

    public long addTo(int key, long additionValue) {
        this.modified();
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public long lget() {
        return this.myMap.lget();
    }

    public long lset(long key) {
        return this.myMap.lset(key);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected long removeImpl(int key) {
        return this.myMap.remove(key);
    }

    public boolean remove(int key, long value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }
}

