/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntList;
import com.almworks.integers.IntLongestIncreasingSubsequence;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongCollections;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.LongOpenHashSet;
import com.almworks.integers.wrappers.LongIntHppcOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLongestCommonSubsequence {
    private final LongList aseq;
    private final LongList bseq;
    private final int alen;
    private final int blen;
    private final int[] lens;
    private final int prefixSize;
    private final int suffixSize;

    private LongLongestCommonSubsequence(LongList aseq, LongList bseq, int prefixSize, int suffixSize) {
        this.aseq = aseq;
        this.bseq = bseq;
        this.alen = aseq.size();
        this.blen = bseq.size();
        this.lens = new int[this.alen * this.blen];
        this.prefixSize = prefixSize;
        this.suffixSize = suffixSize;
    }

    @Nullable
    private static LongList tryLcsForPermutation(LongList aseq, LongList bseq) {
        int sz = aseq.size();
        LongOpenHashSet from = LongOpenHashSet.createFrom((LongIterable)aseq);
        if (sz != bseq.size() || sz != from.size() || !from.containsAll((LongIterable)bseq)) {
            return null;
        }
        return LongLongestCommonSubsequence.getLcsForPermutation(aseq, bseq);
    }

    public static LongList getLcsForPermutation(LongList aseq, LongList bseq) {
        assert (aseq.size() == bseq.size()) : LongCollections.toBoundedString((LongIterable)aseq) + LongCollections.toBoundedString((LongIterable)bseq);
        int sz = aseq.size();
        LongIntHppcOpenHashMap aseqMap = new LongIntHppcOpenHashMap(sz);
        for (int i = 0; i < sz; ++i) {
            assert (!aseqMap.containsKey(aseq.get(i))) : "duplicates aren't allowed in aseq: " + aseq.get(i);
            aseqMap.put(aseq.get(i), i);
        }
        assert (aseqMap.size() == bseq.size() && aseqMap.containsKeys((LongIterable)bseq)) : "bseq should be permutation of aseq: " + LongCollections.toBoundedString((LongIterable)aseqMap.keySet()) + " " + LongCollections.toBoundedString((LongIterable)bseq);
        IntArray ids = new IntArray();
        for (LongIterator it : bseq) {
            ids.add(aseqMap.get(it.value()));
        }
        IntList subseq = IntLongestIncreasingSubsequence.getLIS((IntList)ids);
        LongArray res = new LongArray(subseq.size());
        for (IntIterator it : subseq) {
            res.add(aseq.get(it.value()));
        }
        return res;
    }

    public static LongList getLCS(LongList aseq, LongList bseq) {
        return LongLongestCommonSubsequence.getLCS(aseq, bseq, false);
    }

    public static LongList getLCS(LongList aseq, LongList bseq, boolean tryOptimize) {
        boolean hasSuffix;
        LongList lcs;
        if (aseq == null || bseq == null || aseq.isEmpty() || bseq.isEmpty()) {
            return LongList.EMPTY;
        }
        LongList longList = lcs = tryOptimize ? LongLongestCommonSubsequence.tryLcsForPermutation(aseq, bseq) : null;
        if (lcs != null) {
            return lcs;
        }
        int maxsize = Math.min(aseq.size(), bseq.size());
        LongList prefix = LongLongestCommonSubsequence.getPrefix(aseq, bseq, maxsize);
        if (prefix.size() == maxsize) {
            return prefix;
        }
        LongList suffix = LongLongestCommonSubsequence.getSuffix(aseq, bseq, maxsize);
        if (suffix.size() == maxsize) {
            return suffix;
        }
        boolean hasPrefix = !prefix.isEmpty();
        boolean bl = hasSuffix = !suffix.isEmpty();
        if (hasPrefix) {
            aseq = aseq.subList(prefix.size(), aseq.size());
            bseq = bseq.subList(prefix.size(), bseq.size());
        }
        if (hasSuffix) {
            aseq = aseq.subList(0, aseq.size() - suffix.size());
            bseq = bseq.subList(0, bseq.size() - suffix.size());
        }
        long[] r = new LongLongestCommonSubsequence(aseq, bseq, prefix.size(), suffix.size()).calcLCS();
        if (hasPrefix) {
            prefix.toNativeArray(0, r, 0, prefix.size());
        }
        if (hasSuffix) {
            suffix.toNativeArray(0, r, r.length - suffix.size(), suffix.size());
        }
        return r.length == 0 ? LongList.EMPTY : new LongArray(r);
    }

    private static LongList getSuffix(LongList aseq, LongList bseq, int maxsize) {
        int i;
        int ai = aseq.size();
        int bi = bseq.size();
        for (i = 0; i < maxsize && aseq.get(--ai) == bseq.get(--bi); ++i) {
        }
        return i == 0 ? LongList.EMPTY : aseq.subList(aseq.size() - i, aseq.size());
    }

    @NotNull
    private static LongList getPrefix(@NotNull LongList aseq, @NotNull LongList bseq, int maxsize) {
        int i;
        for (i = 0; i < maxsize && aseq.get(i) == bseq.get(i); ++i) {
        }
        return i == 0 ? LongList.EMPTY : aseq.subList(0, i);
    }

    private long[] calcLCS() {
        for (int i = 0; i < this.alen; ++i) {
            for (int j = 0; j < this.blen; ++j) {
                this.lens[this.p((int)i, (int)j)] = this.aseq.get(i) == this.bseq.get(j) ? this.m(i - 1, j - 1) + 1 : Math.max(this.m(i - 1, j), this.m(i, j - 1));
            }
        }
        int lcslen = this.m(this.alen - 1, this.blen - 1);
        long[] r = new long[this.prefixSize + lcslen + this.suffixSize];
        if (lcslen == 0) {
            return r;
        }
        int ri = lcslen - 1;
        int i = this.alen - 1;
        int j = this.blen - 1;
        while (i >= 0 && j >= 0 && ri >= 0) {
            long v = this.aseq.get(i);
            if (v == this.bseq.get(j)) {
                r[this.prefixSize + ri--] = v;
                --i;
                --j;
                continue;
            }
            if (this.m(i, j - 1) > this.m(i - 1, j)) {
                --j;
                continue;
            }
            --i;
        }
        assert (ri == -1) : ri + " " + i + " " + j + " " + this.aseq + " " + this.bseq;
        return r;
    }

    private String debug() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.alen; ++i) {
            if (i > 0) {
                b.append('\n');
            }
            for (int j = 0; j < this.blen; ++j) {
                b.append(String.format("% 4d", this.lens[this.p(i, j)]));
            }
        }
        return b.toString();
    }

    private int m(int ai, int bi) {
        assert (ai >= -1 && ai < this.alen);
        assert (bi >= -1 && bi < this.blen);
        if (ai < 0 || bi < 0) {
            return 0;
        }
        return this.lens[this.p(ai, bi)];
    }

    private int p(int ai, int bi) {
        assert (ai >= 0 && ai < this.alen);
        assert (bi >= 0 && bi < this.blen);
        return ai * this.blen + bi;
    }
}

