/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableIntObjMap;
import com.almworks.integers.IntFailFastIterator;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.IntObjFailFastIterator;
import com.almworks.integers.IntObjIterable;
import com.almworks.integers.IntObjIterator;
import com.almworks.integers.IntObjIterators;
import com.almworks.integers.IntSizedIterable;
import com.almworks.integers.wrappers.IntHppcWrappers;
import com.almworks.integers.wrappers.IntObjHppcWrappers;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class IntObjHppcOpenHashMap<T>
extends AbstractWritableIntObjMap<T> {
    protected final IntObjectOpenHashMap<T> myMap;

    public IntObjHppcOpenHashMap() {
        this.myMap = new IntObjectOpenHashMap();
    }

    public IntObjHppcOpenHashMap(int initialCapacity) {
        this.myMap = new IntObjectOpenHashMap(initialCapacity);
    }

    public IntObjHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new IntObjectOpenHashMap(initialCapacity, loadFactor);
    }

    public static <T> IntObjHppcOpenHashMap<T> createFrom(IntIterable keys, Iterable<T> values) {
        int keysSize = keys instanceof IntSizedIterable ? ((IntSizedIterable)keys).size() : 0;
        int valuesSize = values instanceof Collection ? ((Collection)keys).size() : 0;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)Math.max(keysSize, valuesSize) / loadFactor) + 1;
        IntObjHppcOpenHashMap<T> map = new IntObjHppcOpenHashMap<T>(initialCapacity);
        IntIterator keysIt = keys.iterator();
        Iterator<T> valuesIt = values.iterator();
        map.putAll((IntObjIterable)IntObjIterators.pair((IntIterator)keysIt, valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static <T> IntObjHppcOpenHashMap<T> createFrom(int[] keys, T[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        IntObjHppcOpenHashMap<T> map = new IntObjHppcOpenHashMap<T>(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static <T> IntObjHppcOpenHashMap<T> createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new IntObjHppcOpenHashMap<T>(initialCapacity, loadFactor);
    }

    public static <T> IntObjHppcOpenHashMap<T> createForAdd(int count) {
        return IntObjHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    @NotNull
    public IntObjIterator<T> iterator() {
        return new IntObjFailFastIterator<T>((IntObjIterator)IntObjHppcWrappers.cursorToIntObjIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return IntObjHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public IntIterator keysIterator() {
        return new IntFailFastIterator(IntHppcWrappers.cursorToIntIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return IntObjHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public Iterator<T> valuesIterator() {
        final Iterator it = this.myMap.values().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return ((ObjectCursor)it.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Collection<T> values() {
        final ObjectContainer valuesContainer = this.myMap.values();
        return new AbstractCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return IntObjHppcOpenHashMap.this.valuesIterator();
            }

            @Override
            public int size() {
                return valuesContainer.size();
            }

            @Override
            public boolean isEmpty() {
                return valuesContainer.isEmpty();
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return valuesContainer.toArray();
            }

            @Override
            public boolean contains(Object o) {
                return valuesContainer.contains(o);
            }
        };
    }

    public T get(int key) {
        return (T)this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected T putImpl(int key, T value) {
        return (T)this.myMap.put(key, value);
    }

    public T lget() {
        return (T)this.myMap.lget();
    }

    public T lset(T value) {
        return (T)this.myMap.lset(value);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected T removeImpl(int key) {
        return (T)this.myMap.remove(key);
    }

    public boolean remove(int key, T value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }
}

