/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableLongIntMap;
import com.almworks.integers.IntCollections;
import com.almworks.integers.IntFailFastIterator;
import com.almworks.integers.IntIterable;
import com.almworks.integers.IntIterator;
import com.almworks.integers.LongCollections;
import com.almworks.integers.LongFailFastIterator;
import com.almworks.integers.LongIntFailFastIterator;
import com.almworks.integers.LongIntIterable;
import com.almworks.integers.LongIntIterator;
import com.almworks.integers.LongIntIterators;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.wrappers.IntHppcWrappers;
import com.almworks.integers.wrappers.LongHppcWrappers;
import com.almworks.integers.wrappers.LongIntHppcWrappers;
import com.carrotsearch.hppc.LongIntOpenHashMap;
import org.jetbrains.annotations.NotNull;

public class LongIntHppcOpenHashMap
extends AbstractWritableLongIntMap {
    protected final LongIntOpenHashMap myMap;

    public LongIntHppcOpenHashMap() {
        this.myMap = new LongIntOpenHashMap();
    }

    public LongIntHppcOpenHashMap(int initialCapacity) {
        this.myMap = new LongIntOpenHashMap(initialCapacity);
    }

    public LongIntHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new LongIntOpenHashMap(initialCapacity, loadFactor);
    }

    public static LongIntHppcOpenHashMap createFrom(LongIterable keys, IntIterable values) {
        int valuesSize;
        int keysSize = LongCollections.sizeOfIterable((LongIterable)keys, (int)0);
        if (keysSize != (valuesSize = IntCollections.sizeOfIterable((IntIterable)values, (int)0))) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        keysSize = Math.max(keysSize, valuesSize);
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)keysSize / loadFactor) + 1;
        LongIntHppcOpenHashMap map = new LongIntHppcOpenHashMap(initialCapacity);
        LongIterator keysIt = keys.iterator();
        IntIterator valuesIt = values.iterator();
        map.putAll((LongIntIterable)LongIntIterators.pair((LongIterable)keysIt, (IntIterable)valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static LongIntHppcOpenHashMap createFrom(long[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        LongIntHppcOpenHashMap map = new LongIntHppcOpenHashMap(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static LongIntHppcOpenHashMap createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new LongIntHppcOpenHashMap(initialCapacity, loadFactor);
    }

    public static LongIntHppcOpenHashMap createForAdd(int count) {
        return LongIntHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(long key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    @NotNull
    public LongIntIterator iterator() {
        return new LongIntFailFastIterator((LongIntIterator)LongIntHppcWrappers.cursorToLongIntIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return LongIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public LongIterator keysIterator() {
        return new LongFailFastIterator(LongHppcWrappers.cursorToLongIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return LongIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public IntIterator valuesIterator() {
        return new IntFailFastIterator(IntHppcWrappers.cursorToIntIterator(this.myMap.values().iterator())){

            protected int getCurrentModCount() {
                return LongIntHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public int get(long key) {
        return this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected int putImpl(long key, int value) {
        return this.myMap.put(key, value);
    }

    public int putOrAdd(long key, int putValue, int additionValue) {
        this.modified();
        return this.myMap.putOrAdd(key, putValue, additionValue);
    }

    public int addTo(long key, int additionValue) {
        this.modified();
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public int lget() {
        return this.myMap.lget();
    }

    public int lset(int value) {
        return this.myMap.lset(value);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected int removeImpl(long key) {
        return this.myMap.remove(key);
    }

    public boolean remove(long key, int value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }
}

