/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableLongLongMap;
import com.almworks.integers.LongCollections;
import com.almworks.integers.LongFailFastIterator;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongLongFailFastIterator;
import com.almworks.integers.LongLongIterable;
import com.almworks.integers.LongLongIterator;
import com.almworks.integers.LongLongIterators;
import com.almworks.integers.wrappers.LongHppcWrappers;
import com.almworks.integers.wrappers.LongLongHppcWrappers;
import com.carrotsearch.hppc.LongLongOpenHashMap;
import org.jetbrains.annotations.NotNull;

public class LongLongHppcOpenHashMap
extends AbstractWritableLongLongMap {
    protected final LongLongOpenHashMap myMap;

    public LongLongHppcOpenHashMap() {
        this.myMap = new LongLongOpenHashMap();
    }

    public LongLongHppcOpenHashMap(int initialCapacity) {
        this.myMap = new LongLongOpenHashMap(initialCapacity);
    }

    public LongLongHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new LongLongOpenHashMap(initialCapacity, loadFactor);
    }

    public static LongLongHppcOpenHashMap createFrom(LongIterable keys, LongIterable values) {
        int valuesSize;
        int keysSize = LongCollections.sizeOfIterable((LongIterable)keys, (int)0);
        if (keysSize != (valuesSize = LongCollections.sizeOfIterable((LongIterable)values, (int)0))) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        keysSize = Math.max(keysSize, valuesSize);
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)keysSize / loadFactor) + 1;
        LongLongHppcOpenHashMap map = new LongLongHppcOpenHashMap(initialCapacity);
        LongIterator keysIt = keys.iterator();
        LongIterator valuesIt = values.iterator();
        map.putAll((LongLongIterable)LongLongIterators.pair((LongIterable)keysIt, (LongIterable)valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static LongLongHppcOpenHashMap createFrom(long[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        LongLongHppcOpenHashMap map = new LongLongHppcOpenHashMap(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static LongLongHppcOpenHashMap createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new LongLongHppcOpenHashMap(initialCapacity, loadFactor);
    }

    public static LongLongHppcOpenHashMap createForAdd(int count) {
        return LongLongHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(long key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    @NotNull
    public LongLongIterator iterator() {
        return new LongLongFailFastIterator((LongLongIterator)LongLongHppcWrappers.cursorToLongLongIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return LongLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public LongIterator keysIterator() {
        return new LongFailFastIterator(LongHppcWrappers.cursorToLongIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return LongLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public LongIterator valuesIterator() {
        return new LongFailFastIterator(LongHppcWrappers.cursorToLongIterator(this.myMap.values().iterator())){

            protected int getCurrentModCount() {
                return LongLongHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public long get(long key) {
        return this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected long putImpl(long key, long value) {
        return this.myMap.put(key, value);
    }

    public long putOrAdd(long key, long putValue, long additionValue) {
        this.modified();
        return this.myMap.putOrAdd(key, putValue, additionValue);
    }

    public long addTo(long key, long additionValue) {
        this.modified();
        return this.putOrAdd(key, additionValue, additionValue);
    }

    public long lget() {
        return this.myMap.lget();
    }

    public long lset(long value) {
        return this.myMap.lset(value);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected long removeImpl(long key) {
        return this.myMap.remove(key);
    }

    public boolean remove(long key, long value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }
}

