/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.integers.wrappers;

import com.almworks.integers.AbstractWritableLongObjMap;
import com.almworks.integers.LongFailFastIterator;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongObjFailFastIterator;
import com.almworks.integers.LongObjIterable;
import com.almworks.integers.LongObjIterator;
import com.almworks.integers.LongObjIterators;
import com.almworks.integers.LongSizedIterable;
import com.almworks.integers.wrappers.LongHppcWrappers;
import com.almworks.integers.wrappers.LongObjHppcWrappers;
import com.carrotsearch.hppc.LongObjectOpenHashMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class LongObjHppcOpenHashMap<T>
extends AbstractWritableLongObjMap<T> {
    protected final LongObjectOpenHashMap<T> myMap;

    public LongObjHppcOpenHashMap() {
        this.myMap = new LongObjectOpenHashMap();
    }

    public LongObjHppcOpenHashMap(int initialCapacity) {
        this.myMap = new LongObjectOpenHashMap(initialCapacity);
    }

    public LongObjHppcOpenHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new LongObjectOpenHashMap(initialCapacity, loadFactor);
    }

    public static <T> LongObjHppcOpenHashMap<T> createFrom(LongIterable keys, Iterable<T> values) {
        int keysSize = keys instanceof LongSizedIterable ? ((LongSizedIterable)keys).size() : 0;
        int valuesSize = values instanceof Collection ? ((Collection)keys).size() : 0;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)Math.max(keysSize, valuesSize) / loadFactor) + 1;
        LongObjHppcOpenHashMap<T> map = new LongObjHppcOpenHashMap<T>(initialCapacity);
        LongIterator keysIt = keys.iterator();
        Iterator<T> valuesIt = values.iterator();
        map.putAll((LongObjIterable)LongObjIterators.pair((LongIterator)keysIt, valuesIt));
        if (keysIt.hasNext() || valuesIt.hasNext()) {
            throw new IllegalArgumentException("keys.size() != values.size()");
        }
        return map;
    }

    public static <T> LongObjHppcOpenHashMap<T> createFrom(long[] keys, T[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        int size = keys.length;
        float loadFactor = 0.75f;
        int initialCapacity = (int)((float)size / loadFactor) + 1;
        LongObjHppcOpenHashMap<T> map = new LongObjHppcOpenHashMap<T>(initialCapacity, loadFactor);
        map.putAll(keys, values);
        return map;
    }

    public static <T> LongObjHppcOpenHashMap<T> createForAdd(int count, float loadFactor) {
        int initialCapacity = (int)((float)count / loadFactor) + 1;
        return new LongObjHppcOpenHashMap<T>(initialCapacity, loadFactor);
    }

    public static <T> LongObjHppcOpenHashMap<T> createForAdd(int count) {
        return LongObjHppcOpenHashMap.createForAdd(count, 0.75f);
    }

    public boolean containsKey(long key) {
        return this.myMap.containsKey(key);
    }

    public int size() {
        return this.myMap.size();
    }

    @NotNull
    public LongObjIterator<T> iterator() {
        return new LongObjFailFastIterator<T>((LongObjIterator)LongObjHppcWrappers.cursorToLongObjIterator(this.myMap.iterator())){

            protected int getCurrentModCount() {
                return LongObjHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public LongIterator keysIterator() {
        return new LongFailFastIterator(LongHppcWrappers.cursorToLongIterator(this.myMap.keys().iterator())){

            protected int getCurrentModCount() {
                return LongObjHppcOpenHashMap.this.myModCount;
            }
        };
    }

    public Iterator<T> valuesIterator() {
        final Iterator it = this.myMap.values().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return ((ObjectCursor)it.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Collection<T> values() {
        final ObjectContainer valuesContainer = this.myMap.values();
        return new AbstractCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return LongObjHppcOpenHashMap.this.valuesIterator();
            }

            @Override
            public int size() {
                return valuesContainer.size();
            }

            @Override
            public boolean isEmpty() {
                return valuesContainer.isEmpty();
            }

            @Override
            @NotNull
            public Object[] toArray() {
                return valuesContainer.toArray();
            }

            @Override
            public boolean contains(Object o) {
                return valuesContainer.contains(o);
            }
        };
    }

    public T get(long key) {
        return (T)this.myMap.get(key);
    }

    public void clear() {
        this.myMap.clear();
    }

    protected T putImpl(long key, T value) {
        return (T)this.myMap.put(key, value);
    }

    public T lget() {
        return (T)this.myMap.lget();
    }

    public T lset(T value) {
        return (T)this.myMap.lset(value);
    }

    public int lslot() {
        return this.myMap.lslot();
    }

    protected T removeImpl(long key) {
        return (T)this.myMap.remove(key);
    }

    public boolean remove(long key, T value) {
        this.modified();
        if (!this.containsKey(key)) {
            return false;
        }
        if (this.myMap.lget() != value) {
            return false;
        }
        this.myMap.remove(key);
        return true;
    }
}

