/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface FastLaneConfig {
  /**
   * Default port that is used if nothing else is configured.
   */
  static final int DEFAULT_PORT = 8090;

  /**
   * Default thread idle timeout.
   */
  static final int DEFAULT_THREAD_IDLE_TIMEOUT = 5 * 60 * 1000;

  static final int DEFAULT_MIN_THREADS = 10;

  static final int DEFAULT_MAX_THREADS = 50;

  int port() default DEFAULT_PORT;

  int maxThreads() default DEFAULT_MAX_THREADS;

  int minThreads() default DEFAULT_MIN_THREADS;

  /**
   * Idle time after which a thread will be stopped and removed from pool. Timeout is defined in milliseconds.
   */
  int threadIdleTimeout() default DEFAULT_THREAD_IDLE_TIMEOUT;
}
