/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

public class WebContainerStateInfo {
  private final String name;

  private final WebContainerState status;

  private final int activeRequests;

  private final String threadPrefix;

  private final int threadPoolSize;

  private final int minThreads;

  private final int maxThreads;

  private final int maxQueueSize;

  private final int queueSize;

  public WebContainerStateInfo( String pName, WebContainerState pStatus, String pThreadPrefix, int pThreadPoolSize, int pMinThreads,
      int pMaxThreads, int pActiveRequests, int pMaxQueueSize, int pQueueSize ) {
    name = pName;
    status = pStatus;
    threadPrefix = pThreadPrefix;
    threadPoolSize = pThreadPoolSize;
    minThreads = pMinThreads;
    maxThreads = pMaxThreads;
    activeRequests = pActiveRequests;
    maxQueueSize = pMaxQueueSize;

    queueSize = pQueueSize;
  }

  public String getName( ) {
    return name;
  }

  public WebContainerState getState( ) {
    return status;
  }

  public int getActiveRequests( ) {
    return activeRequests;
  }

  public String getThreadPrefix( ) {
    return threadPrefix;
  }

  public int getThreadPoolSize( ) {
    return threadPoolSize;
  }

  public int getMinThreads( ) {
    return minThreads;
  }

  public int getMaxThreads( ) {
    return maxThreads;
  }

  public int getMaxQueueSize( ) {
    return maxQueueSize;
  }

  public int getQueueSize( ) {
    return queueSize;
  }
}
