/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.anaptecs.jeaf.fastlane.annotations.FastLaneConfig;
import com.anaptecs.jeaf.fastlane.annotations.ServletMapping;
import com.anaptecs.jeaf.fastlane.api.FastLane;
import com.anaptecs.jeaf.xfun.api.config.AnnotationBasedConfiguration;

public class AnnotationBasedFastLaneConfigurationImpl extends AnnotationBasedConfiguration<FastLaneConfig>
    implements FastLaneConfiguration {

  public AnnotationBasedFastLaneConfigurationImpl( ) {
    // Call super class constructor.
    this(FastLaneConfig.FAST_LANE_CONFIG_RESOURCE_NAME, FastLane.FASTLANE_BASE_PATH, true);
  }

  public AnnotationBasedFastLaneConfigurationImpl( String pCustomConfigurationResourceName,
      String pCustomConfigurationBasePackagePath, boolean pExceptionOnError ) {
    super(pCustomConfigurationResourceName, pCustomConfigurationBasePackagePath, pExceptionOnError);
  }

  @Override
  protected Class<FastLaneConfig> getAnnotationClass( ) {
    return FastLaneConfig.class;
  }

  @Override
  protected String getDefaultConfigurationClass( ) {
    return FastLaneDefaultConfiguration.class.getName();
  }

  @Override
  public FastLaneConfig getEmptyConfiguration( ) {
    return new FastLaneConfig() {

      @Override
      public Class<? extends Annotation> annotationType( ) {
        return FastLaneConfig.class;
      }

      @Override
      public int port( ) {
        return FastLaneConfig.DEFAULT_PORT;
      }

      @Override
      public int minThreads( ) {
        return FastLaneConfig.DEFAULT_WORKLOAD_MIN_THREADS;
      }

      @Override
      public int maxThreads( ) {
        return FastLaneConfig.DEFAULT_WORKLOAD_MAX_THREADS;
      }

      @Override
      public boolean enableManagementInterface( ) {
        return FastLaneConfig.DEFAULT_MANAGAMENT_INTERFACE_ENABLED;
      }

      @Override
      public int managementPort( ) {
        return FastLaneConfig.DEFAULT_MANAGEMENT_PORT;
      }

      @Override
      public int minManagementThreads( ) {
        return FastLaneConfig.DEFAULT_MIN_MANAGEMENT_THREADS;
      }

      @Override
      public int maxManagementThreads( ) {
        return FastLaneConfig.DEFAULT_MAX_MANAGEMENT_THREADS;
      }

      @Override
      public int threadIdleTimeout( ) {
        return FastLaneConfig.DEFAULT_THREAD_IDLE_TIMEOUT;
      }

      @Override
      public int initialQueueSize( ) {
        return FastLaneConfig.DEFAULT_INITIAL_QUEUE_SIZE;
      }

      @Override
      public int maxQueueSize( ) {
        return FastLaneConfig.DEFAULT_MAX_QUEUE_SIZE;
      }

      @Override
      public int queueGrowSize( ) {
        return FastLaneConfig.DEFAULT_QUEUE_GROW_SIZE;
      }

      @Override
      public int inputBufferSize( ) {
        return FastLaneConfig.DEFAULT_INPUT_BUFFER_SIZE;
      }

      @Override
      public int outputBufferSize( ) {
        return FastLaneConfig.DEFAULT_OUTPUT_BUFFER_SIZE;
      }

      @Override
      public String contextPath( ) {
        return FastLaneConfig.DEFAULT_CONTEXT_PATH;
      }

      @Override
      public String restPath( ) {
        return FastLaneConfig.DEFAULT_REST_PATH;
      }

      @Override
      public boolean enableREST( ) {
        return FastLaneConfig.DEFAULT_REST_ENABLED;
      }

      @Override
      public boolean enableWebServlets( ) {
        return FastLaneConfig.DEFAULT_WEB_SERVLET_ENABLED;
      }

      @Override
      public String managementPath( ) {
        return FastLaneConfig.DEFAULT_MANAGEMENT_PATH;
      }

      @Override
      public int httpIOIdleTimeout( ) {
        return FastLaneConfig.DEFAULT_HTTP_IO_IDLE_TIMEOUT;
      }

      @Override
      public boolean sendServerVersion( ) {
        return FastLaneConfig.DEFAULT_SEND_SERVER_VERSION;
      }

      @Override
      public boolean sendXPoweredBy( ) {
        return FastLaneConfig.DEFAULT_SEND_X_POWERED_BY;
      }

      @Override
      public boolean gracefulShutdown( ) {
        return DEFAULT_GRACEFUL_SHUTDOWN;
      }

      @Override
      public int gracefulShutdownTimeout( ) {
        return DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;
      }

      @Override
      public boolean stopServerOnError( ) {
        return FastLaneConfig.DEFAULT_STOP_SERVER_ON_ERROR;
      }

      @Override
      public boolean traceUncaughtErrors( ) {
        return FastLaneConfig.DEFAULT_TRACE_UNCAUGHT_ERRORS;
      }

      @Override
      public boolean stopServerOnRuntimeException( ) {
        return FastLaneConfig.DEFAULT_STOP_SERVER_ON_RUNTIME_EXCEPTION;
      }

      @Override
      public boolean traceUncaughtRuntimeExceptions( ) {
        return FastLaneConfig.DEFAULT_TRACE_UNCAUGHT__RUNTIME_EXCEPTIONS;
      }

      @Override
      public boolean enableJMX( ) {
        return FastLaneConfig.DEFAULT_JMX_ENABLED;
      }

      @Override
      public ServletMapping[] servletMappings( ) {
        return new ServletMapping[] {};
      }
    };
  }

  @Override
  public List<String> checkCustomConfiguration( FastLaneConfig pCustomConfiguration ) {
    // Standard and management port must not be the same
    List<String> lErrors = new ArrayList<>(1);
    if (pCustomConfiguration.port() == pCustomConfiguration.managementPort()
        && pCustomConfiguration.enableManagementInterface() == true) {
      lErrors.add(
          "Workload and management web container must not use the same port. Currently both are configured to use port "
              + theConfig.port());
    }
    return lErrors;
  }

  @Override
  public int getPort( ) {
    return theConfig.port();
  }

  @Override
  public int getMinThreads( ) {
    return theConfig.minThreads();
  }

  @Override
  public int getMaxThreads( ) {
    return theConfig.maxThreads();
  }

  @Override
  public boolean isManagementInterfaceEnabled( ) {
    return theConfig.enableManagementInterface();
  }

  @Override
  public int getManagementPort( ) {
    return theConfig.managementPort();
  }

  @Override
  public int getMinManagementThreads( ) {
    return theConfig.minManagementThreads();
  }

  @Override
  public int getMaxManagementThreads( ) {
    return theConfig.maxManagementThreads();
  }

  @Override
  public int getThreadIdleTimeout( ) {
    return theConfig.threadIdleTimeout();
  }

  @Override
  public int getInitialQueueSize( ) {
    return theConfig.initialQueueSize();
  }

  @Override
  public int getMaxQueueSize( ) {
    return theConfig.maxQueueSize();
  }

  @Override
  public int getQueueGrowSize( ) {
    return theConfig.queueGrowSize();
  }

  @Override
  public int getInputBufferSize( ) {
    return theConfig.inputBufferSize();
  }

  @Override
  public int getOutputBufferSize( ) {
    return theConfig.outputBufferSize();
  }

  @Override
  public String getContextPath( ) {
    return theConfig.contextPath();
  }

  @Override
  public String getRESTPath( ) {
    return theConfig.restPath();
  }

  @Override
  public boolean isRESTEnabled( ) {
    return theConfig.enableREST();
  }

  @Override
  public boolean isWebServletsEnabled( ) {
    return theConfig.enableWebServlets();
  }

  @Override
  public String getManagementPath( ) {
    return theConfig.managementPath();
  }

  @Override
  public int getHTTPIOIdleTimeout( ) {
    return theConfig.httpIOIdleTimeout();
  }

  @Override
  public boolean sendServerVersion( ) {
    return theConfig.sendServerVersion();
  }

  @Override
  public boolean sendXPoweredBy( ) {
    return theConfig.sendXPoweredBy();
  }

  @Override
  public boolean isGracefulShutdownEnabled( ) {
    return theConfig.gracefulShutdown();
  }

  @Override
  public int getGracefulShutdownTimeout( ) {
    return theConfig.gracefulShutdownTimeout();
  }

  @Override
  public boolean stopServerOnError( ) {
    return theConfig.stopServerOnError();
  }

  @Override
  public boolean traceUncaughtErrors( ) {
    return theConfig.traceUncaughtErrors();
  }

  @Override
  public boolean stopServerOnRuntimeException( ) {
    return theConfig.stopServerOnRuntimeException();
  }

  @Override
  public boolean traceUncaughtRuntimeExceptions( ) {
    return theConfig.traceUncaughtRuntimeExceptions();
  }

  @Override
  public boolean isJMXEnabled( ) {
    return theConfig.enableJMX();
  }

  @Override
  public List<ServletMapping> getServletMappings( ) {
    return Arrays.asList(theConfig.servletMappings());
  }
}
