/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

import java.util.List;

import com.anaptecs.jeaf.fastlane.annotations.FastLaneConfig;
import com.anaptecs.jeaf.fastlane.annotations.ServletMapping;

/**
 * Interface define methods to read all supported JEAF Fast Lane configuration paramaters from a source.
 */
public interface FastLaneConfiguration {
  /**
   * {@link FastLaneConfig#contextPath()}
   */
  String getContextPath( );

  /**
   * {@link FastLaneConfig#enableREST()}
   */
  boolean isRESTEnabled( );

  /**
   * {@link FastLaneConfig#restPath()}
   */
  String getRESTPath( );

  /**
   * {@link FastLaneConfig#enableWebServlets()}
   */
  boolean isWebServletsEnabled( );

  /**
   * {@link FastLaneConfig#port()}
   */
  int getPort( );

  /**
   * {@link FastLaneConfig#minThreads()}
   */
  int getMinThreads( );

  /**
   * {@link FastLaneConfig#maxThreads()}
   */
  int getMaxThreads( );

  /**
   * {@link FastLaneConfig#managementPath()}
   */
  String getManagementPath( );

  /**
   * {@link FastLaneConfig#enableManagementInterface()}
   */
  boolean isManagementInterfaceEnabled( );

  /**
   * {@link FastLaneConfig#annotationType()#getManagementPort()}
   */
  int getManagementPort( );

  /**
   * {@link FastLaneConfig#minManagementThreads()}
   */
  int getMinManagementThreads( );

  /**
   * {@link FastLaneConfig#maxManagementThreads()}
   */
  int getMaxManagementThreads( );

  /**
   * {@link FastLaneConfig#threadIdleTimeout()}
   */
  int getThreadIdleTimeout( );

  /**
   * {@link FastLaneConfig#httpIOIdleTimeout()}
   */
  int getHTTPIOIdleTimeout( );

  /**
   * {@link FastLaneConfig#initialQueueSize()}
   */
  int getInitialQueueSize( );

  /**
   * {@link FastLaneConfig#maxQueueSize()}
   */
  int getMaxQueueSize( );

  /**
   * {@link FastLaneConfig#queueGrowSize()}
   */
  int getQueueGrowSize( );

  /**
   * {@link FastLaneConfig#inputBufferSize()}
   */
  int getInputBufferSize( );

  /**
   * {@link FastLaneConfig#outputBufferSize()}
   */
  int getOutputBufferSize( );

  /**
   * {@link FastLaneConfig#sendServerVersion()}
   */
  boolean sendServerVersion( );

  /**
   * {@link FastLaneConfig#sendXPoweredBy()}
   */
  boolean sendXPoweredBy( );

  /**
   * {@link FastLaneConfig#gracefulShutdown()}
   */
  boolean isGracefulShutdownEnabled( );

  /**
   * {@link FastLaneConfig#gracefulShutdownTimeout()}
   */
  int getGracefulShutdownTimeout( );

  /**
   * {@link FastLaneConfig#stopServerOnError()}
   */
  boolean stopServerOnError( );

  /**
   * {@link FastLaneConfig#traceUncaughtErrors()}
   */
  boolean traceUncaughtErrors( );

  /**
   * {@link FastLaneConfig#stopServerOnRuntimeException()}
   */
  boolean stopServerOnRuntimeException( );

  /**
   * {@link FastLaneConfig#traceUncaughtRuntimeExceptions()}
   */
  boolean traceUncaughtRuntimeExceptions( );

  /**
   * {@link FastLaneConfig#enableJMX()}
   */
  boolean isJMXEnabled( );

  /**
   * {@link FastLaneConfig#servletMappings()}
   */
  List<ServletMapping> getServletMappings( );
}
