package com.anaptecs.jeaf.fastlane.impl;

import com.anaptecs.jeaf.xfun.annotations.MessageResource;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;

/**
 * Class contains constants for all messages of JEAF Fast Lane
 *
 * @author JEAF Development Team
 * @version JEAF Release 1.5
 */
@MessageResource(path = "jeaf-fast-lane-messages.xml")
public final class FastLaneMessages {
  /**
   * Constant for XML file that contains all messages that are defined within this class.
   */
  private static final String MESSAGE_RESOURCE = "jeaf-fast-lane-messages.xml";

  /**
   * Error code is used when starting of web container failed for some reason
   */
  public static final ErrorCode WEB_CONTAINER_START_FAILED;

  /**
   * Error code is used when stopping of web container failed for some reason.
   */
  public static final ErrorCode WEB_CONTAINER_STOP_FAILED;
  /**
   * Static initializer contains initialization for all generated constants.
   */
  static {
    MessageRepository lRepository = XFun.getMessageRepository();
    lRepository.loadResource(MESSAGE_RESOURCE);
    // Handle all info messages.
    // Handle all messages for errors.
    WEB_CONTAINER_START_FAILED = lRepository.getErrorCode(7000);
    WEB_CONTAINER_STOP_FAILED = lRepository.getErrorCode(7001);
    // Handle all localized strings.
  }

  /**
   * Constructor is private to ensure that no instances of this class will be created.
   */
  private FastLaneMessages( ) {
    // Nothing to do.
  }
}