/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

/**
 * Interface defines all information and methods that are accessible via JMX.
 */
public interface FastLaneServerMBean {
  /**
   * Method returns the state of the JEAF Fast Lane Server.
   */
  String getServerState( );

  /**
   * Method can be used to shut down JEAF Fast Lane Server via JMX.
   * 
   * @param pWaitTime Wait time for until the shutdown is started.
   * @param pExitCode Exit code that should be used.
   */
  void requestShutdown( int pWaitTime, int pExitCode );
}
