/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;

@WebFilter(value = "/management/*", asyncSupported = true, displayName = "Management Filter")
public class ManagementFilter implements Filter {
  public static final String FAST_LANE_SERVER_KEY = "FastLaneServer";

  private final FastLaneServer server;

  public ManagementFilter( FastLaneServer pServer ) {
    server = pServer;
  }

  @Override
  public void init( FilterConfig pFilterConfig ) throws ServletException {
    // Nothing to do.
  }

  @Override
  public void doFilter( ServletRequest pRequest, ServletResponse pResponse, FilterChain pChain )
    throws IOException, ServletException {

    ServletContext lServletContext = pRequest.getServletContext();
    try {
      // Add reference to JEAF Fast Lane Server to servlet context.
      lServletContext.setAttribute(FAST_LANE_SERVER_KEY, server);
      pChain.doFilter(pRequest, pResponse);
    }
    finally {
      lServletContext.removeAttribute(FAST_LANE_SERVER_KEY);
    }
  }

  @Override
  public void destroy( ) {
    // Nothing to do.
  }
}
