/**
 * Copyright 2004 - 2021 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.fastlane.impl;

import java.util.Collections;
import java.util.List;

import com.anaptecs.jeaf.fastlane.annotations.FastLaneConfig;
import com.anaptecs.jeaf.fastlane.annotations.ServletMapping;

/**
 * Class implements a JEAF Fast Lane configuration source that reads the configuration from a YAML file.
 */
public class YAMLFastLaneConfigurationImpl implements FastLaneConfiguration {
  /**
   * {@link FastLaneConfig#contextPath()}
   */
  private String contextPath = FastLaneConfig.DEFAULT_CONTEXT_PATH;

  /**
   * {@link FastLaneConfig#enableREST()}
   */
  private boolean restEnabled = FastLaneConfig.DEFAULT_REST_ENABLED;

  /**
   * {@link FastLaneConfig#restPath()}
   */
  private String restPath = FastLaneConfig.DEFAULT_REST_PATH;

  /**
   * {@link FastLaneConfig#enableWebServlets()}
   */
  private boolean webServletsEnabled = FastLaneConfig.DEFAULT_WEB_SERVLET_ENABLED;

  /**
   * {@link FastLaneConfig#port()}
   */
  private int port = FastLaneConfig.DEFAULT_PORT;

  /**
   * {@link FastLaneConfig#minThreads()}
   */
  private int minThreads = FastLaneConfig.DEFAULT_WORKLOAD_MIN_THREADS;

  /**
   * {@link FastLaneConfig#maxThreads()}
   */
  private int maxThreads = FastLaneConfig.DEFAULT_WORKLOAD_MAX_THREADS;

  /**
   * {@link FastLaneConfig#enableManagementInterface()}
   */
  private boolean managementInterfaceEnabled = FastLaneConfig.DEFAULT_MANAGAMENT_INTERFACE_ENABLED;

  /**
   * {@link FastLaneConfig#managementPort()}
   */
  private int managementPort = FastLaneConfig.DEFAULT_MANAGEMENT_PORT;

  /**
   * {@link FastLaneConfig#managementPath()}
   */
  private String managementPath = FastLaneConfig.DEFAULT_MANAGEMENT_PATH;

  /**
   * {@link FastLaneConfig#minManagementThreads()}
   */
  private int minManagementThreads = FastLaneConfig.DEFAULT_MIN_MANAGEMENT_THREADS;

  /**
   * {@link FastLaneConfig#maxManagementThreads()}
   */
  private int maxManagementThreads = FastLaneConfig.DEFAULT_MAX_MANAGEMENT_THREADS;

  /**
   * {@link FastLaneConfig#threadIdleTimeout()}
   */
  private int threadIdleTimeout = FastLaneConfig.DEFAULT_THREAD_IDLE_TIMEOUT;

  /**
   * {@link FastLaneConfig#httpIOIdleTimeout()}
   */
  private int httpIOIdleTimeout = FastLaneConfig.DEFAULT_HTTP_IO_IDLE_TIMEOUT;

  /**
   * {@link FastLaneConfig#initialQueueSize()}
   */
  private int initialQueueSize = FastLaneConfig.DEFAULT_INITIAL_QUEUE_SIZE;

  /**
   * {@link FastLaneConfig#maxQueueSize()}
   */
  private int maxQueueSize = FastLaneConfig.DEFAULT_MAX_QUEUE_SIZE;

  /**
   * {@link FastLaneConfig#queueGrowSize()}
   */
  private int queueGrowSize = FastLaneConfig.DEFAULT_QUEUE_GROW_SIZE;

  /**
   * {@link FastLaneConfig#inputBufferSize()}
   */
  private int inputBufferSize = FastLaneConfig.DEFAULT_INPUT_BUFFER_SIZE;

  /**
   * {@link FastLaneConfig#outputBufferSize()}
   */
  private int outputBufferSize = FastLaneConfig.DEFAULT_OUTPUT_BUFFER_SIZE;

  /**
   * {@link FastLaneConfig#sendServerVersion()}
   */
  private boolean sendServerVersion = FastLaneConfig.DEFAULT_SEND_SERVER_VERSION;

  /**
   * {@link FastLaneConfig#sendXPoweredBy()}
   */
  private boolean sendXPoweredBy = FastLaneConfig.DEFAULT_SEND_X_POWERED_BY;

  /**
   * {@link FastLaneConfig#gracefulShutdown()}
   */
  private boolean gracefulShutdownEnabled = FastLaneConfig.DEFAULT_GRACEFUL_SHUTDOWN;

  /**
   * {@link FastLaneConfig#gracefulShutdownTimeout()}
   */
  private int gracefulShutdownTimeout = FastLaneConfig.DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT;

  /**
   * {@link FastLaneConfig#stopServerOnError()}
   */
  private boolean stopServerOnError = FastLaneConfig.DEFAULT_STOP_SERVER_ON_ERROR;

  /**
   * {@link FastLaneConfig#traceUncaughtErrors()}
   */
  private boolean traceUncaughtErrors = FastLaneConfig.DEFAULT_TRACE_UNCAUGHT_ERRORS;

  /**
   * {@link FastLaneConfig#stopServerOnRuntimeException()}
   */
  private boolean stopServerOnRuntimeException = FastLaneConfig.DEFAULT_STOP_SERVER_ON_RUNTIME_EXCEPTION;

  /**
   * {@link FastLaneConfig#traceUncaughtRuntimeExceptions()}
   */
  private boolean traceUncaughtRuntimeExceptions = FastLaneConfig.DEFAULT_TRACE_UNCAUGHT__RUNTIME_EXCEPTIONS;

  /**
   * {@link FastLaneConfig#enableJMX()}
   */
  private boolean jmxEnabled = FastLaneConfig.DEFAULT_JMX_ENABLED;

  @Override
  public int getPort( ) {
    return port;
  }

  @Override
  public int getMinThreads( ) {
    return minThreads;
  }

  @Override
  public int getMaxThreads( ) {
    return maxThreads;
  }

  @Override
  public boolean isManagementInterfaceEnabled( ) {
    return managementInterfaceEnabled;
  }

  @Override
  public int getManagementPort( ) {
    return managementPort;
  }

  @Override
  public int getMinManagementThreads( ) {
    return minManagementThreads;
  }

  @Override
  public int getMaxManagementThreads( ) {
    return maxManagementThreads;
  }

  @Override
  public int getThreadIdleTimeout( ) {
    return threadIdleTimeout;
  }

  @Override
  public int getInitialQueueSize( ) {
    return initialQueueSize;
  }

  @Override
  public int getMaxQueueSize( ) {
    return maxQueueSize;
  }

  @Override
  public int getQueueGrowSize( ) {
    return queueGrowSize;
  }

  @Override
  public int getInputBufferSize( ) {
    return inputBufferSize;
  }

  @Override
  public int getOutputBufferSize( ) {
    return outputBufferSize;
  }

  @Override
  public String getContextPath( ) {
    return contextPath;
  }

  @Override
  public String getRESTPath( ) {
    return restPath;
  }

  @Override
  public boolean isRESTEnabled( ) {
    return restEnabled;
  }

  @Override
  public boolean isWebServletsEnabled( ) {
    return webServletsEnabled;
  }

  @Override
  public String getManagementPath( ) {
    return managementPath;
  }

  @Override
  public int getHTTPIOIdleTimeout( ) {
    return httpIOIdleTimeout;
  }

  @Override
  public boolean sendServerVersion( ) {
    return sendServerVersion;
  }

  @Override
  public boolean sendXPoweredBy( ) {
    return sendXPoweredBy;
  }

  @Override
  public boolean isGracefulShutdownEnabled( ) {
    return gracefulShutdownEnabled;
  }

  @Override
  public int getGracefulShutdownTimeout( ) {
    return gracefulShutdownTimeout;
  }

  @Override
  public boolean stopServerOnError( ) {
    return stopServerOnError;
  }

  @Override
  public boolean traceUncaughtErrors( ) {
    return traceUncaughtErrors;
  }

  @Override
  public boolean stopServerOnRuntimeException( ) {
    return stopServerOnRuntimeException;
  }

  @Override
  public boolean traceUncaughtRuntimeExceptions( ) {
    return traceUncaughtRuntimeExceptions;
  }

  @Override
  public boolean isJMXEnabled( ) {
    return jmxEnabled;
  }

  @Override
  public List<ServletMapping> getServletMappings( ) {
    return Collections.emptyList();
  }

  public void setPort( int pPort ) {
    port = pPort;
  }

  public void setMinThreads( int pMinThreads ) {
    minThreads = pMinThreads;
  }

  public void setMaxThreads( int pMaxThreads ) {
    maxThreads = pMaxThreads;
  }

  public void setManagementInterfaceEnabled( boolean pManagementInterfaceEnabled ) {
    managementInterfaceEnabled = pManagementInterfaceEnabled;
  }

  public void setManagementPort( int pManagementPort ) {
    managementPort = pManagementPort;
  }

  public void setMinManagementThreads( int pMinManagementThreads ) {
    minManagementThreads = pMinManagementThreads;
  }

  public void setMaxManagementThreads( int pMaxManagementThreads ) {
    maxManagementThreads = pMaxManagementThreads;
  }

  public void setThreadIdleTimeout( int pThreadIdleTimeout ) {
    threadIdleTimeout = pThreadIdleTimeout;
  }

  public void setInitialQueueSize( int pInitialQueueSize ) {
    initialQueueSize = pInitialQueueSize;
  }

  public void setMaxQueueSize( int pMaxQueueSize ) {
    maxQueueSize = pMaxQueueSize;
  }

  public void setQueueGrowSize( int pQueueGrowSize ) {
    queueGrowSize = pQueueGrowSize;
  }

  public void setInputBufferSize( int pInputBufferSize ) {
    inputBufferSize = pInputBufferSize;
  }

  public void setOutputBufferSize( int pOutputBufferSize ) {
    outputBufferSize = pOutputBufferSize;
  }

  public void setContextPath( String pContextPath ) {
    contextPath = pContextPath;
  }

  public void setRestPath( String pRestPath ) {
    restPath = pRestPath;
  }

  public void setRestEnabled( boolean pRestEnabled ) {
    restEnabled = pRestEnabled;
  }

  public void setWebServletsEnabled( boolean pWebServletsEnabled ) {
    webServletsEnabled = pWebServletsEnabled;
  }

  public void setManagementPath( String pManagementPath ) {
    managementPath = pManagementPath;
  }

  public void setHttpIOIdleTimeout( int pHttpIOIdleTimeout ) {
    httpIOIdleTimeout = pHttpIOIdleTimeout;
  }

  public void setSendServerVersion( boolean pSendServerVersion ) {
    sendServerVersion = pSendServerVersion;
  }

  public void setSendXPoweredBy( boolean pSendXPoweredBy ) {
    sendXPoweredBy = pSendXPoweredBy;
  }

  public void setGracefulShutdownEnabled( boolean pGracefulShutdownEnabled ) {
    gracefulShutdownEnabled = pGracefulShutdownEnabled;
  }

  public void setGracefulShutdownTimeout( int pGracefulShutdownTimeout ) {
    gracefulShutdownTimeout = pGracefulShutdownTimeout;
  }

  public void setStopServerOnError( boolean pStopServerOnError ) {
    stopServerOnError = pStopServerOnError;
  }

  public void setTraceUncaughtErrors( boolean pTraceUncaughtErrors ) {
    traceUncaughtErrors = pTraceUncaughtErrors;
  }

  public void setStopServerOnRuntimeException( boolean pStopServerOnRuntimeException ) {
    stopServerOnRuntimeException = pStopServerOnRuntimeException;
  }

  public void setTraceUncaughtRuntimeExceptions( boolean pTraceUncaughtRuntimeExceptions ) {
    traceUncaughtRuntimeExceptions = pTraceUncaughtRuntimeExceptions;
  }

  public void setJmxEnabled( boolean pJmxEnabled ) {
    jmxEnabled = pJmxEnabled;
  }
}
