/**
 * Copyright 2004 - 2022 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.jersey.impl.time;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;

import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

/**
 * Class implements a JAX-RS parameter converter provider. This class can be used when working with java.time.* classes
 * 
 * @author JEAF Development Team
 */
@Provider
public class JavaTimeConverterProvider implements ParamConverterProvider {

  @SuppressWarnings("unchecked")
  @Override
  public <T> ParamConverter<T> getConverter( Class<T> pRawType, Type pGenericType, Annotation[] pAnnotations ) {
    ParamConverter<T> lParamConverter;

    // Handle local times
    // LocalDateTime
    if (LocalDateTime.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new LocalDateTimeParamConverter();
    }
    // LocalDate
    else if (LocalDate.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new LocalDateParamConverter();
    }

    // LocalTime
    else if (LocalTime.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new LocalTimeParamConverter();
    }

    // Handle offset times
    else if (OffsetDateTime.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new OffsetDateTimeParamConverter();
    }
    else if (OffsetTime.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new OffsetTimeParamConverter();
    }

    // Handle Calendar
    else if (Calendar.class.equals(pRawType)) {
      lParamConverter = (ParamConverter<T>) new CalendarParamConverter();
    }
    // No converter available for the passed type.
    else {
      lParamConverter = null;
    }
    return lParamConverter;
  }
}
