/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.maven;

import com.anaptecs.jeaf.maven.AnnotationProcessingConfig;
import com.anaptecs.jeaf.maven.ClassInfoComparator;
import com.anaptecs.jeaf.maven.ClassOccurrencePolicy;
import com.anaptecs.jeaf.maven.NameFilter;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.xfun.api.checks.Assert;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class AnnotationBasedConfigGenerator {
    private final Log log;
    private final String resourceGenDirectory;
    private final String testResourceGenDirectory;
    private final String targetDirectory;
    private final String testTargetDirectory;
    private final ScanResult scanResult;
    private final List<String> classpath;

    public AnnotationBasedConfigGenerator(String pResourceGenDirectory, String pTestResourceGenDirectory, String pTargetDirectory, String pTestTargetDirectory, ScanResult pScanResult, Log pLog, List<String> pClasspath) {
        Assert.assertNotNull((Object)pScanResult, (String)"pScanResult");
        Assert.assertNotNull(pClasspath, (String)"pClasspath");
        Assert.assertNotNull((Object)pLog, (String)"pLog");
        this.resourceGenDirectory = pResourceGenDirectory;
        this.testResourceGenDirectory = pTestResourceGenDirectory;
        this.targetDirectory = pTargetDirectory;
        this.testTargetDirectory = pTestTargetDirectory;
        this.scanResult = pScanResult;
        this.classpath = pClasspath;
        this.log = pLog;
    }

    public void generate(AnnotationProcessingConfig pAnnotationProcessingConfig, NameFilter pFilter, boolean pTestScope) throws IOException {
        Assert.assertNotNull(pAnnotationProcessingConfig.getAnnotation(), (String)"AnnotationProcessingConfig.getAnnotation()");
        Assert.assertNotNull((Object)pAnnotationProcessingConfig.getFilePath(), (String)"AnnotationProcessingConfig.getFilePath()");
        Assert.assertNotNull((Object)pFilter, (String)"pFilter");
        this.log.info((CharSequence)" ");
        List<String> lClassNames = this.detectAndFilterAnnotatedClasses(this.scanResult, pAnnotationProcessingConfig.getAnnotation(), pFilter, pAnnotationProcessingConfig.getPolicy());
        this.writeConfigFile(lClassNames, pAnnotationProcessingConfig.getFilePath(), pTestScope);
    }

    private List<String> detectAndFilterAnnotatedClasses(ScanResult pScanResult, Class<? extends Annotation> pAnnotation, NameFilter pFilter, ClassOccurrencePolicy pPolicy) {
        Assert.assertNotNull((Object)pScanResult, (String)"pScanResult");
        Assert.assertNotNull(pAnnotation, (String)"pAnnotation");
        Assert.assertNotNull((Object)pFilter, (String)"pFilter");
        Assert.assertNotNull((Object)((Object)pPolicy), (String)"pPolicy");
        ClassInfoList lAnnotatedClasses = pScanResult.getClassesWithAnnotation(pAnnotation.getName());
        ClassInfoComparator lComparator = new ClassInfoComparator(this.classpath);
        lAnnotatedClasses.sort((Comparator)lComparator);
        this.log.info((CharSequence)("@" + pAnnotation.getSimpleName() + ":"));
        ArrayList<String> lClassNamesList = new ArrayList<String>();
        for (ClassInfo lNextClass : lAnnotatedClasses) {
            String lClassName = lNextClass.getName();
            if (!pFilter.isFilteredOut(lClassName)) {
                lClassNamesList.add(lClassName);
                this.log.info((CharSequence)("    " + lClassName + " (included)"));
                continue;
            }
            this.log.info((CharSequence)("    " + lClassName + " (ignored due to defined includes / excludes)"));
        }
        switch (pPolicy) {
            case ALL_CLASSES: {
                break;
            }
            case FIRST_CLASS: {
                int lSize = lClassNamesList.size();
                if (lSize > 0) {
                    String lFirst = (String)lClassNamesList.get(0);
                    lClassNamesList.clear();
                    lClassNamesList.add(lFirst);
                    if (lSize <= 1) break;
                    this.log.info((CharSequence)("Using only annotated class " + lFirst + ". All other classes are ignored due to class occurrence configuiration " + ClassOccurrencePolicy.FIRST_CLASS.name() + "."));
                    break;
                }
                this.log.warn((CharSequence)("No class with annotation @" + pAnnotation.getSimpleName() + " found in classpath. This may be a problem with your classpath or the configuration of this Maven Plugin."));
                break;
            }
            case ONE_CLASS_ONLY: {
                if (lClassNamesList.size() <= 1) break;
                String lMessage = "Problem in classpath detected. We found more then one class with annotation @" + pAnnotation.getName() + ". Please cleanup your classpath or change configuration of occurrence policy of this Maven Plugin.";
                this.log.error((CharSequence)lMessage);
                throw new RuntimeException(lMessage);
            }
            case EXACTLY_ONE_CLASS_ONLY: {
                if (lClassNamesList.size() <= 1) break;
                String lMessage = "Problem in classpath detected. We expect to find exactly one class with annotation @" + pAnnotation.getName() + ". Please cleanup your classpath or change configuration of occurrence policy of this Maven Plugin.";
                this.log.error((CharSequence)lMessage);
                throw new RuntimeException(lMessage);
            }
        }
        this.log.info((CharSequence)" ");
        ArrayList<String> lClassNames = new ArrayList<String>(lClassNamesList);
        Collections.sort(lClassNames);
        return lClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfigFile(List<String> pLines, String pFilePath, boolean pTestScope) throws IOException {
        try (Writer lWriter = null;){
            File lOutputFileInTargetDir;
            File lOutputFile;
            File lOutputDirectory;
            if (!pTestScope) {
                Assert.assertNotNull((Object)this.resourceGenDirectory, (String)"resourceGenDirectory");
                lOutputDirectory = new File(this.resourceGenDirectory + File.separatorChar + pFilePath).getParentFile();
                lOutputFile = new File(this.resourceGenDirectory + File.separatorChar + pFilePath);
                lOutputFileInTargetDir = this.targetDirectory != null ? new File(this.targetDirectory + File.separatorChar + pFilePath) : null;
            } else {
                Assert.assertNotNull((Object)this.testResourceGenDirectory, (String)"testResourceGenDirectory");
                lOutputDirectory = new File(this.testResourceGenDirectory + File.separatorChar + pFilePath).getParentFile();
                lOutputFile = new File(this.testResourceGenDirectory + File.separatorChar + pFilePath);
                lOutputFileInTargetDir = this.testTargetDirectory != null ? new File(this.testTargetDirectory + File.separatorChar + pFilePath) : null;
            }
            if (!lOutputDirectory.exists()) {
                lOutputDirectory.mkdirs();
            }
            if (lOutputFile.exists()) {
                lOutputFile.delete();
            }
            lWriter = new BufferedWriter(new FileWriter(lOutputFile, false));
            for (String lNextLine : pLines) {
                lWriter.write(lNextLine);
                lWriter.write(10);
            }
            lWriter.close();
            lWriter = null;
            if (!pLines.isEmpty()) {
                this.log.info((CharSequence)("Created JEAF config file " + lOutputFile.getCanonicalPath()));
            }
            if (lOutputFileInTargetDir != null) {
                if (lOutputFileInTargetDir.exists()) {
                    lOutputFileInTargetDir.delete();
                } else {
                    File lParentDirectory = lOutputFileInTargetDir.getParentFile();
                    if (!lParentDirectory.exists()) {
                        lParentDirectory.mkdirs();
                    }
                }
                Tools.getFileTools().copyFile(lOutputFile, lOutputFileInTargetDir);
                if (!pLines.isEmpty()) {
                    this.log.info((CharSequence)("Created configuration file also in target directory: " + lOutputFileInTargetDir.getCanonicalPath()));
                }
            }
        }
    }
}

