/**
 * Copyright 2004 - 2019 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.maven;

import java.lang.annotation.Annotation;

public class AnnotationProcessingConfig {
  private final Class<? extends Annotation> annotation;

  private final String filePath;

  private final ClassOccurrencePolicy policy;

  private final boolean enabled;

  public AnnotationProcessingConfig( Class<? extends Annotation> pAnnotation, String pFilePath,
      ClassOccurrencePolicy pPolicy, boolean pEnabaled ) {
    annotation = pAnnotation;
    filePath = pFilePath;
    policy = pPolicy;
    enabled = pEnabaled;
  }

  public Class<? extends Annotation> getAnnotation( ) {
    return annotation;
  }

  public String getFilePath( ) {
    return filePath;
  }

  public ClassOccurrencePolicy getPolicy( ) {
    return policy;
  }

  public boolean isEnabled( ) {
    return enabled;
  }
}