/**
 * Copyright 2004 - 2019 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.maven;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;

import io.github.classgraph.ClassInfo;

public class ClassInfoComparator implements Comparator<ClassInfo> {
  private final List<String> classpath;

  public ClassInfoComparator( List<String> pClasspath ) {
    classpath = pClasspath;
  }

  @Override
  public int compare( ClassInfo pFirstClassInfo, ClassInfo pSecondClassInfo ) {
    try {
      String lFirstClassPathElement = pFirstClassInfo.getClasspathElementFile().getCanonicalPath();
      String lSecondClassPathElement = pSecondClassInfo.getClasspathElementFile().getCanonicalPath();
      int lFirstClasspathIndex = classpath.indexOf(lFirstClassPathElement);
      int lSecondClasspathIndex = classpath.indexOf(lSecondClassPathElement);

      int lCompareResult;
      if (lFirstClasspathIndex < lSecondClasspathIndex) {
        lCompareResult = -1;
      }
      else if (lFirstClasspathIndex == lSecondClasspathIndex) {
        lCompareResult = pFirstClassInfo.getName().compareTo(pSecondClassInfo.getName());
      }
      else {
        lCompareResult = 1;
      }
      return lCompareResult;
    }
    catch (IOException e) {
      throw new RuntimeException(e.getMessage(), e);
    }
  }
}
