/**
 * Copyright 2004 - 2019 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.maven;

/**
 * Enumeration defines the available policies for handling cases where more than one class with an annotation was found.
 * 
 * @author JEAF Development Team
 * @version JEAF Release 2.0
 */
public enum ClassOccurrencePolicy {
  /**
   * Use all classes.
   */
  ALL_CLASSES,

  /**
   * Use first class that occurs in classpath, but one class is required.
   */
  FIRST_CLASS,

  /**
   * We expect one class only, but we can also live with no occurrence.
   */
  ONE_CLASS_ONLY,

  /**
   * We expect exactly one occurrence in classpath. If none or multiple where found then we ran into an error.
   */
  EXACTLY_ONE_CLASS_ONLY;
}
