/**
 * Copyright 2004 - 2019 anaptecs GmbH, Burgstr. 96, 72764 Reutlingen, Germany
 *
 * All rights reserved.
 */
package com.anaptecs.jeaf.maven;

import java.lang.annotation.Annotation;

public class AnnotationProcessingConfig {
  private final Class<? extends Annotation> annotation;

  private final String filePath;

  private final ClassOccurrencePolicy policy;

  private final boolean enabled;

  private final boolean sorted;

  public AnnotationProcessingConfig( Class<? extends Annotation> pAnnotation, String pFilePath,
      ClassOccurrencePolicy pPolicy, boolean pEnabled ) {

    this(pAnnotation, pFilePath, pPolicy, pEnabled, true);
  }

  public AnnotationProcessingConfig( Class<? extends Annotation> pAnnotation, String pFilePath,
      ClassOccurrencePolicy pPolicy, boolean pEnabled, boolean pSorted ) {
    annotation = pAnnotation;
    filePath = pFilePath;
    policy = pPolicy;
    enabled = pEnabled;
    sorted = pSorted;
  }

  public Class<? extends Annotation> getAnnotation( ) {
    return annotation;
  }

  public String getFilePath( ) {
    return filePath;
  }

  public ClassOccurrencePolicy getPolicy( ) {
    return policy;
  }

  public boolean isEnabled( ) {
    return enabled;
  }
  
  public boolean isSorted( ) {
    return sorted;
  }
}