/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.maven;

import com.anaptecs.jeaf.core.annotations.ComponentFactory;
import com.anaptecs.jeaf.core.annotations.CoreConfig;
import com.anaptecs.jeaf.core.annotations.CoreFactory;
import com.anaptecs.jeaf.core.annotations.EJBClientServiceChannelConfig;
import com.anaptecs.jeaf.core.annotations.EJBContainerConfig;
import com.anaptecs.jeaf.core.annotations.JEAFActivityImpl;
import com.anaptecs.jeaf.core.annotations.LifecycleManagerFactory;
import com.anaptecs.jeaf.core.annotations.SchedulerCredentials;
import com.anaptecs.jeaf.core.annotations.SchedulingConfig;
import com.anaptecs.jeaf.core.annotations.SecurityConfig;
import com.anaptecs.jeaf.core.annotations.ServiceProviderFactory;
import com.anaptecs.jeaf.fastlane.annotations.FastLaneConfig;
import com.anaptecs.jeaf.json.annotations.ModuleFactory;
import com.anaptecs.jeaf.json.annotations.ObjectMapperConfig;
import com.anaptecs.jeaf.maven.AnnotationBasedConfigGenerator;
import com.anaptecs.jeaf.maven.AnnotationProcessingConfig;
import com.anaptecs.jeaf.maven.ClassOccurrencePolicy;
import com.anaptecs.jeaf.maven.ExplicitConfig;
import com.anaptecs.jeaf.maven.NameFilter;
import com.anaptecs.jeaf.maven.Scanner;
import com.anaptecs.jeaf.spi.persistence.annotations.PersistenceConfig;
import com.anaptecs.jeaf.tools.annotations.EncodingToolsConfig;
import com.anaptecs.jeaf.tools.annotations.EncryptionToolsConfig;
import com.anaptecs.jeaf.tools.annotations.MonitoringToolsConfig;
import com.anaptecs.jeaf.tools.annotations.NetworkingToolsConfig;
import com.anaptecs.jeaf.tools.annotations.StreamToolsConfig;
import com.anaptecs.jeaf.tools.annotations.ToolsImplementation;
import com.anaptecs.jeaf.tools.annotations.XMLToolsConfig;
import com.anaptecs.jeaf.tools.api.Tools;
import com.anaptecs.jeaf.tools.api.performance.Stopwatch;
import com.anaptecs.jeaf.tools.api.performance.TimePrecision;
import com.anaptecs.jeaf.workload.annotations.ElasticWorkloadConfig;
import com.anaptecs.jeaf.workload.annotations.PipelineConfig;
import com.anaptecs.jeaf.workload.annotations.StaticWorkloadConfig;
import com.anaptecs.jeaf.workload.annotations.WorkloadManagementConfig;
import com.anaptecs.jeaf.xfun.annotations.AppInfo;
import com.anaptecs.jeaf.xfun.annotations.ConfigurationProviderConfig;
import com.anaptecs.jeaf.xfun.annotations.DatatypeConverterImpl;
import com.anaptecs.jeaf.xfun.annotations.MessageResource;
import com.anaptecs.jeaf.xfun.annotations.RuntimeInfo;
import com.anaptecs.jeaf.xfun.annotations.StartupInfoConfig;
import com.anaptecs.jeaf.xfun.annotations.StartupInfoWriterImpl;
import com.anaptecs.jeaf.xfun.annotations.TraceConfig;
import com.anaptecs.jeaf.xfun.annotations.TraceObjectFormatter;
import com.anaptecs.jeaf.xfun.annotations.XFunConfig;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebServlet;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="GenerateJEAFConfig", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class GenerateConfigMojo
extends AbstractMojo {
    public static final String JEAF_META_INF_DIRECTORY = "META-INF/JEAF";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(name="resourceGenDirectory", required=false)
    private String resourceGenDirectory;
    @Parameter(name="testResourceGenDirectory", required=false)
    private String testResourceGenDirectory;
    @Parameter(name="targetDirectory", required=false)
    private String targetDirectory;
    @Parameter(name="testTargetDirectory", required=false)
    private String testTargetDirectory;
    @Parameter(name="includes")
    private List<String> includes = new ArrayList<String>(0);
    @Parameter(name="excludes")
    private List<String> excludes = new ArrayList<String>();
    @Parameter(defaultValue="true", required=false)
    private boolean enableDefaultExcludes;
    @Parameter(defaultValue="false", required=false)
    private boolean cleanMetaInfDirectory;
    @Parameter(defaultValue="false", required=false)
    private boolean cleanOnly;
    @Parameter(defaultValue="true", required=false)
    private boolean detectMessageResources;
    @Parameter(defaultValue="true", required=false)
    private boolean detectComponentFactories;
    @Parameter(defaultValue="true", required=false)
    private boolean detectServiceProviderFactories;
    @Parameter(defaultValue="true", required=false)
    private boolean detectActivities;
    @Parameter(defaultValue="true", required=false)
    private boolean detectAppInfo;
    @Parameter(defaultValue="true", required=false)
    private boolean detectRuntimeInfo;
    @Parameter(defaultValue="true", required=false)
    private boolean detectConfigurationProviderConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectTraceConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectTraceObjectFormatter;
    @Parameter(defaultValue="true", required=false)
    private boolean detectXFunConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectLifecycleManagerFactory;
    @Parameter(defaultValue="true", required=false)
    private boolean detectDatatypeConverterImpls;
    @Parameter(defaultValue="true", required=false)
    private boolean detectToolsImplementation;
    @Parameter(defaultValue="true", required=false)
    private boolean detectStartupInfoConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectStartupInfoWriterImpl;
    @Parameter(defaultValue="true", required=false)
    private boolean detectCoreFactory;
    @Parameter(defaultValue="true", required=false)
    private boolean detectCoreConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectObjectMapperConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectModuleFactories;
    @Parameter(defaultValue="true", required=false)
    private boolean detectSchedulingConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectSecurityConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectSchedulerCredentials;
    @Parameter(defaultValue="true", required=false)
    private boolean detectWorkloadManagerConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectWorkloadMappings;
    @Parameter(defaultValue="true", required=false)
    private boolean detectPipelineConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectEJBClientServiceChannelConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectEJBContainerConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectPersistenceConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean detectFastLaneConfig;
    @Parameter(defaultValue="true", required=false)
    private boolean createVersionInfo;
    @Parameter
    private ExplicitConfig explicitConfigurationDetection;
    @Parameter(defaultValue="${project.version}", required=true, readonly=true)
    private String version;
    @Parameter(defaultValue="META-INF/JEAF/XFun/VersionInfo", required=false)
    private String versionInfoPath;
    private NameFilter filter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block10: {
            try {
                List<String> lDefaultExcludes;
                this.configurePlugin();
                if (this.enableDefaultExcludes) {
                    lDefaultExcludes = Arrays.asList("org.glassfish.jersey.*", "com.anaptecs.jeaf.fastlane.impl.ManagementResource");
                    this.getLog().info((CharSequence)("Adding default excludes: " + lDefaultExcludes));
                } else {
                    lDefaultExcludes = Collections.emptyList();
                }
                this.filter = new NameFilter(this.includes, this.excludes, lDefaultExcludes);
                if (this.cleanMetaInfDirectory) {
                    this.cleanMetaInfDirectories();
                }
                if (this.cleanOnly) break block10;
                if (this.resourceGenDirectory != null || this.testResourceGenDirectory != null) {
                    if (this.resourceGenDirectory != null) {
                        this.generateConfigs(false);
                    }
                    if (this.testResourceGenDirectory != null) {
                        this.generateConfigs(true);
                    }
                    break block10;
                }
                throw new MojoFailureException("'resourceGenDirectory' or 'testRessourceGenDirectory' or both must be configured. Please check plugins configuration.");
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
            catch (Error | RuntimeException e) {
                this.getLog().error(e);
                throw new MojoFailureException(e.getMessage(), e);
            }
        }
    }

    private void configurePlugin() {
        System.setProperty("log4j2.configurationFile", "jeaf-maven-plugin-log4j2.xml");
        if (this.explicitConfigurationDetection != null) {
            this.disableAll();
            if (this.explicitConfigurationDetection.detectXFunConfigs) {
                this.createVersionInfo = true;
                this.detectAppInfo = true;
                this.detectConfigurationProviderConfig = true;
                this.detectDatatypeConverterImpls = true;
                this.detectMessageResources = true;
                this.detectRuntimeInfo = true;
                this.detectStartupInfoConfig = true;
                this.detectStartupInfoWriterImpl = true;
                this.detectTraceConfig = true;
                this.detectTraceObjectFormatter = true;
                this.detectXFunConfig = true;
            }
            if (this.explicitConfigurationDetection.detectToolsConfigs) {
                this.detectToolsImplementation = true;
            }
            if (this.explicitConfigurationDetection.detectCoreConfigs) {
                this.detectActivities = true;
                this.detectComponentFactories = true;
                this.detectCoreConfig = true;
                this.detectCoreFactory = true;
                this.detectEJBClientServiceChannelConfig = true;
                this.detectEJBContainerConfig = true;
                this.detectLifecycleManagerFactory = true;
                this.detectSchedulerCredentials = true;
                this.detectSchedulingConfig = true;
                this.detectSecurityConfig = true;
                this.detectServiceProviderFactories = true;
            }
            if (this.explicitConfigurationDetection.detectJSONConfigs) {
                this.detectObjectMapperConfig = true;
                this.detectModuleFactories = true;
            }
            if (this.explicitConfigurationDetection.detectPersistenceConfigs) {
                this.detectPersistenceConfig = true;
            }
            if (this.explicitConfigurationDetection.detectWorkloadConfigs) {
                this.detectPipelineConfig = true;
                this.detectWorkloadManagerConfig = true;
                this.detectWorkloadMappings = true;
            }
            if (this.explicitConfigurationDetection.detectFastLaneConfig) {
                this.detectFastLaneConfig = true;
            }
        }
    }

    private void disableAll() {
        this.createVersionInfo = false;
        this.detectAppInfo = false;
        this.detectXFunConfig = false;
        this.detectConfigurationProviderConfig = false;
        this.detectDatatypeConverterImpls = false;
        this.detectMessageResources = false;
        this.detectRuntimeInfo = false;
        this.detectStartupInfoConfig = false;
        this.detectStartupInfoWriterImpl = false;
        this.detectTraceConfig = false;
        this.detectTraceObjectFormatter = false;
        this.detectToolsImplementation = false;
        this.detectActivities = false;
        this.detectComponentFactories = false;
        this.detectCoreConfig = false;
        this.detectCoreFactory = false;
        this.detectObjectMapperConfig = false;
        this.detectModuleFactories = false;
        this.detectEJBClientServiceChannelConfig = false;
        this.detectEJBContainerConfig = false;
        this.detectLifecycleManagerFactory = false;
        this.detectSchedulerCredentials = false;
        this.detectSchedulingConfig = false;
        this.detectSecurityConfig = false;
        this.detectServiceProviderFactories = false;
        this.detectPersistenceConfig = false;
        this.detectPipelineConfig = false;
        this.detectWorkloadManagerConfig = false;
        this.detectWorkloadMappings = false;
        this.detectFastLaneConfig = false;
    }

    private void cleanMetaInfDirectories() {
        String lMetaInfDirectory;
        File lDirectory;
        if (this.resourceGenDirectory != null && (lDirectory = new File(lMetaInfDirectory = this.resourceGenDirectory + File.separatorChar + JEAF_META_INF_DIRECTORY)).exists()) {
            this.getLog().info((CharSequence)("Cleaning directory " + lMetaInfDirectory));
            Tools.getFileTools().deleteRecursive(lMetaInfDirectory);
        }
        if (this.testResourceGenDirectory != null && (lDirectory = new File(lMetaInfDirectory = this.testResourceGenDirectory + File.separatorChar + JEAF_META_INF_DIRECTORY)).exists()) {
            this.getLog().info((CharSequence)("Cleaning directory " + lMetaInfDirectory));
            Tools.getFileTools().deleteRecursive(lMetaInfDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateConfigs(boolean pTestScope) throws IOException, DependencyResolutionRequiredException {
        AnnotationBasedConfigGenerator lGenerator = null;
        try (ScanResult lScanResult = null;){
            Stopwatch lStopwatch = Tools.getPerformanceTools().createStopwatch("Classpath scan took: ", TimePrecision.MILLIS);
            lStopwatch.start();
            List<String> lClasspathPaths = this.getDependencyPaths(pTestScope);
            Scanner lScanner = new Scanner();
            lScanResult = lScanner.scan(lClasspathPaths);
            lGenerator = new AnnotationBasedConfigGenerator(this.resourceGenDirectory, this.testResourceGenDirectory, this.targetDirectory, this.testTargetDirectory, lScanResult, this.getLog(), lClasspathPaths);
            lStopwatch.stopAndTrace();
            ArrayList<AnnotationProcessingConfig> lSupportedAnnotations = new ArrayList<AnnotationProcessingConfig>();
            lSupportedAnnotations.add(new AnnotationProcessingConfig(MessageResource.class, "META-INF/JEAF/XFun/MessageResources", ClassOccurrencePolicy.ALL_CLASSES, this.detectMessageResources));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ComponentFactory.class, "META-INF/JEAF/Core/ComponentFactories", ClassOccurrencePolicy.ALL_CLASSES, this.detectComponentFactories));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ServiceProviderFactory.class, "META-INF/JEAF/Core/ServiceProviderFactories", ClassOccurrencePolicy.ALL_CLASSES, this.detectServiceProviderFactories));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(JEAFActivityImpl.class, "META-INF/JEAF/Core/Activities", ClassOccurrencePolicy.ALL_CLASSES, this.detectActivities));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(AppInfo.class, "META-INF/JEAF/XFun/ApplicationInfo", ClassOccurrencePolicy.FIRST_CLASS, this.detectAppInfo));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(RuntimeInfo.class, "META-INF/JEAF/XFun/RuntimeInfo", ClassOccurrencePolicy.FIRST_CLASS, this.detectRuntimeInfo));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ConfigurationProviderConfig.class, "META-INF/JEAF/XFun/ConfigurationProviderConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectConfigurationProviderConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(TraceConfig.class, "META-INF/JEAF/XFun/TraceConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectTraceConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(TraceObjectFormatter.class, "META-INF/JEAF/XFun/TraceObjectFormatters", ClassOccurrencePolicy.ALL_CLASSES, this.detectTraceObjectFormatter));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(XFunConfig.class, "META-INF/JEAF/XFun/XFunConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectXFunConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(LifecycleManagerFactory.class, "META-INF/JEAF/Core/LifecycleManagerFactory", ClassOccurrencePolicy.FIRST_CLASS, this.detectLifecycleManagerFactory));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(DatatypeConverterImpl.class, "META-INF/JEAF/XFun/DatatypeConverters", ClassOccurrencePolicy.ALL_CLASSES, this.detectDatatypeConverterImpls));
            boolean lSorted = false;
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ToolsImplementation.class, "META-INF/JEAF/Tools/ToolsImplementation", ClassOccurrencePolicy.ALL_CLASSES, this.detectToolsImplementation, lSorted));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(EncodingToolsConfig.class, "META-INF/JEAF/Tools/EncodingToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(EncryptionToolsConfig.class, "META-INF/JEAF/Tools/EncryptionToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(StreamToolsConfig.class, "META-INF/JEAF/Tools/StreamToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(XMLToolsConfig.class, "META-INF/JEAF/Tools/XMLToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(NetworkingToolsConfig.class, "META-INF/JEAF/Tools/NetworkingToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(MonitoringToolsConfig.class, "META-INF/JEAF/Tools/MonitoringToolsConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectToolsImplementation));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(StartupInfoConfig.class, "META-INF/JEAF/XFun/StartupInfoConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectStartupInfoConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(StartupInfoWriterImpl.class, "META-INF/JEAF/XFun/StartupInfoWriters", ClassOccurrencePolicy.ALL_CLASSES, this.detectStartupInfoWriterImpl));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(CoreFactory.class, "META-INF/JEAF/Core/CoreFactory", ClassOccurrencePolicy.FIRST_CLASS, this.detectCoreFactory));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(CoreConfig.class, "META-INF/JEAF/Core/CoreConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectCoreConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(SchedulingConfig.class, "META-INF/JEAF/Core/SchedulingConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectSchedulingConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(SecurityConfig.class, "META-INF/JEAF/Core/SecurityConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectSecurityConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(SchedulerCredentials.class, "META-INF/JEAF/Core/SchedulerCredentials", ClassOccurrencePolicy.ONE_CLASS_ONLY, this.detectSchedulerCredentials));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(WorkloadManagementConfig.class, "META-INF/JEAF/Workload/WorkloadManager", ClassOccurrencePolicy.ONE_CLASS_ONLY, this.detectWorkloadManagerConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(PipelineConfig.class, "META-INF/JEAF/Workload/PipelineConfigs", ClassOccurrencePolicy.ALL_CLASSES, this.detectPipelineConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(StaticWorkloadConfig.class, "META-INF/JEAF/Workload/StaticWorkloads", ClassOccurrencePolicy.ALL_CLASSES, this.detectWorkloadMappings));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ElasticWorkloadConfig.class, "META-INF/JEAF/Workload/ElasticWorkloads", ClassOccurrencePolicy.ALL_CLASSES, this.detectWorkloadMappings));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(EJBClientServiceChannelConfig.class, "META-INF/JEAF/Core/EJBClientServiceChannelConfig", ClassOccurrencePolicy.ONE_CLASS_ONLY, this.detectEJBClientServiceChannelConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(EJBContainerConfig.class, "META-INF/JEAF/Core/EJBContainerConfig", ClassOccurrencePolicy.ONE_CLASS_ONLY, this.detectEJBContainerConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ObjectMapperConfig.class, "META-INF/JEAF/JSON/ObjectMapperConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectObjectMapperConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(ModuleFactory.class, "META-INF/JEAF/JSON/ModuleFactoryConfig", ClassOccurrencePolicy.ALL_CLASSES, this.detectModuleFactories));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(PersistenceConfig.class, "META-INF/JEAF/Persistence/PersistenceConfig", ClassOccurrencePolicy.ALL_CLASSES, this.detectPersistenceConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(Path.class, "META-INF/JEAF/FastLane/RESTResource", ClassOccurrencePolicy.ALL_CLASSES, this.detectFastLaneConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(WebServlet.class, "META-INF/JEAF/FastLane/WebServlet", ClassOccurrencePolicy.ALL_CLASSES, this.detectFastLaneConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(WebFilter.class, "META-INF/JEAF/FastLane/WebFilter", ClassOccurrencePolicy.ALL_CLASSES, this.detectFastLaneConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(Provider.class, "META-INF/JEAF/FastLane/Provider", ClassOccurrencePolicy.ALL_CLASSES, this.detectFastLaneConfig));
            lSupportedAnnotations.add(new AnnotationProcessingConfig(FastLaneConfig.class, "META-INF/JEAF/FastLane/FastLaneConfig", ClassOccurrencePolicy.FIRST_CLASS, this.detectFastLaneConfig));
            for (AnnotationProcessingConfig lAnnotationProcessingConfig : lSupportedAnnotations) {
                if (!lAnnotationProcessingConfig.isEnabled()) continue;
                lGenerator.generate(lAnnotationProcessingConfig, this.filter, pTestScope);
            }
            if (this.createVersionInfo) {
                Log lLog = this.getLog();
                lLog.info((CharSequence)" ");
                lLog.info((CharSequence)"Version-Info:");
                Date lBuildStartTime = this.session.getStartTime();
                String lCreationDate = Tools.getDateTools().toTimestampString(lBuildStartTime);
                ArrayList<String> lProperties = new ArrayList<String>();
                lProperties.add("VERSION=" + this.version);
                lProperties.add("CREATION_DATE=" + lCreationDate);
                for (String lValue : lProperties) {
                    lLog.info((CharSequence)("    " + lValue));
                }
                lLog.info((CharSequence)" ");
                lGenerator.writeConfigFile(lProperties, this.versionInfoPath, pTestScope);
            }
        }
    }

    private List<String> getDependencyPaths(boolean pTestScope) throws IOException, DependencyResolutionRequiredException {
        List<String> lDependencyPaths = pTestScope ? this.project.getTestClasspathElements() : this.project.getRuntimeClasspathElements();
        lDependencyPaths = lDependencyPaths.stream().filter(s -> !s.endsWith(".ear") && !s.endsWith(".war")).collect(Collectors.toList());
        this.getLog().info((CharSequence)"Detected the following Maven dependencies:");
        for (String lNextclasspathEntry : lDependencyPaths) {
            this.getLog().info((CharSequence)("    " + lNextclasspathEntry));
        }
        return lDependencyPaths;
    }
}

