/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.maven;

import com.anaptecs.jeaf.maven.FilterMode;
import com.anaptecs.jeaf.maven.FilterType;
import com.anaptecs.jeaf.xfun.api.checks.Check;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NameFilter {
    private final FilterMode filterMode;
    private final List<String> filterExpressions;

    public NameFilter(List<String> pIncludes, List<String> pExcludes, List<String> pDefaultExcludes) {
        Check.checkInvalidParameterNull(pDefaultExcludes, (String)"pDefaultExcludes");
        if (pIncludes != null && pExcludes != null && !pIncludes.isEmpty() && !pExcludes.isEmpty()) {
            throw new RuntimeException("Either configuration parameter 'includes' or 'excludes' or none can be used but not both.");
        }
        if (pIncludes != null && !pIncludes.isEmpty()) {
            this.filterExpressions = new ArrayList<String>(pIncludes);
            this.filterMode = FilterMode.INCLUDE;
        } else if (pExcludes != null && !pExcludes.isEmpty()) {
            this.filterExpressions = new ArrayList<String>(pExcludes);
            this.filterExpressions.addAll(pDefaultExcludes);
            this.filterMode = FilterMode.EXCLUDE;
        } else if (!pDefaultExcludes.isEmpty()) {
            this.filterExpressions = new ArrayList<String>(pDefaultExcludes);
            this.filterMode = FilterMode.EXCLUDE;
        } else {
            this.filterExpressions = Collections.emptyList();
            this.filterMode = FilterMode.NO_FILTERING;
        }
    }

    public boolean isFilteredOut(String pName) {
        boolean lFilteredOut;
        String lNextFilter;
        boolean lMatchesFilter = false;
        Iterator<String> iterator = this.filterExpressions.iterator();
        while (iterator.hasNext() && !(lMatchesFilter = this.matchesFilter(pName, lNextFilter = iterator.next()))) {
        }
        switch (this.filterMode) {
            case EXCLUDE: {
                lFilteredOut = lMatchesFilter;
                break;
            }
            case INCLUDE: {
                lFilteredOut = !lMatchesFilter;
                break;
            }
            case NO_FILTERING: {
                lFilteredOut = false;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected filter mode: " + this.filterMode.name());
            }
        }
        return lFilteredOut;
    }

    private boolean matchesFilter(String pName, String pFilter) {
        boolean lMatches;
        FilterType lFilterType = this.detectFilterType(pFilter);
        switch (lFilterType) {
            case STARTS_WITH: {
                lMatches = pName.startsWith(pFilter.substring(0, pFilter.length() - 2));
                break;
            }
            case ENDSWITH: {
                lMatches = pName.endsWith(pFilter.substring(1));
                break;
            }
            case CONTAINS: {
                lMatches = pName.contains(pFilter.substring(1, pFilter.length() - 2));
                break;
            }
            case EXACT_MATCH: {
                lMatches = pName.equals(pFilter);
                break;
            }
            default: {
                throw new RuntimeException("Internal error: Unexpected filter type " + lFilterType.name());
            }
        }
        return lMatches;
    }

    private FilterType detectFilterType(String pFilter) {
        FilterType lFilterType = pFilter.startsWith("*") && pFilter.endsWith("*") ? FilterType.CONTAINS : (pFilter.startsWith("*") ? FilterType.ENDSWITH : (pFilter.endsWith("*") ? FilterType.STARTS_WITH : FilterType.EXACT_MATCH));
        return lFilterType;
    }
}

