/*
 * anaptecs GmbH, Ricarda-Huch-Str. 71, 72760 Reutlingen, Germany
 * 
 * Copyright 2004 - 2019. All rights reserved.
 */
package com.anaptecs.jeaf.services.migration;

import java.util.List;

import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.xfun.api.errorhandling.FailureMessage;

/**
 * Service defines an generic interface for the migration of a component. What has to be done during migration highly
 * depends on the implementing component.
 * 
 * @author JEAF Generator
 * @version JEAF Release 1.4.x
 */
public interface MigrationService extends Service {
  /**
   * Method runs the migration routine of the implementing component.
   * 
   * 
   * @return {@link FailureMessage} List with all problems that occurred during the migration
   * 
   */
  List<FailureMessage> runMigration( );
}
