/*
 * anaptecs GmbH, Ricarda-Huch-Str. 71, 72760 Reutlingen, Germany
 * 
 * Copyright 2004 - 2019. All rights reserved.
 */
package com.anaptecs.jeaf.services.scheduling;

import java.util.Set;

import com.anaptecs.jeaf.core.api.Service;

/**
 * @author JEAF Generator
 * @version JEAF Release 1.4.x
 */
public interface SchedulerService extends Service {
  /**
   * 
   * @return {@link ScheduledTask}
   */
  Set<ScheduledTask> lockExpiredTasks( );

  /**
   * 
   * @param pTask
   * @throws {@link SchedulingSystemException}
   */
  void executeTask( ScheduledTask pTask ) throws SchedulingSystemException;

  /**
   * 
   * @param pTask
   * @param pExecutionException
   * @param pTrigger
   */
  void addExecutionResult( ScheduledTask pTask, Exception pExecutionException, ExecutionTrigger pTrigger );
}
