/*
 * anaptecs GmbH, Ricarda-Huch-Str. 71, 72760 Reutlingen, Germany
 * 
 * Copyright 2004 - 2019. All rights reserved.
 */
package com.anaptecs.jeaf.services.scheduling;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.core.servicechannel.api.ServiceProxy;
import com.anaptecs.jeaf.core.spi.TransactionBehavior;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ApplicationException;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;

/**
 * ServiceProxy class for JEAF service SchedulerService.
 */
public final class SchedulerServiceProxy extends ServiceProxy implements SchedulerService {
  /**
   * Serial version uid for the proxy class.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Initialize object.
   *
   * @param pTransactionBehavior Definition of transactional behavior. The Parameter must not be null.
   */
  public SchedulerServiceProxy( TransactionBehavior pTransactionBehavior ) {
    super(SchedulerService.class, pTransactionBehavior);
  }

  /**
   * Generated proxy implementation for method "lockExpiredTasks".
   * 
   * 
   */
  @SuppressWarnings("unchecked")
  public Set<ScheduledTask> lockExpiredTasks( ) {
    try {
      Command lCommand = new LockExpiredTasks_SchedulerService_Command();
      return (Set<ScheduledTask>) this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "executeTask".
   * 
   * 
   */
  public void executeTask( ScheduledTask pTask ) throws SchedulingSystemException {
    try {
      Command lCommand = new ExecuteTask_ScheduledTask_SchedulerService_Command(pTask);
      this.executeCommand(lCommand);
    }
    catch (SchedulingSystemException e) {
      throw e;
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "addExecutionResult".
   * 
   * 
   */
  public void addExecutionResult( ScheduledTask pTask, Exception pExecutionException, ExecutionTrigger pTrigger ) {
    try {
      Command lCommand = new AddExecutionResult_ScheduledTask_Exception_ExecutionTrigger_SchedulerService_Command(pTask,
          pExecutionException, pTrigger);
      this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }
}

/**
 * Generated command class for service method "lockExpiredTasks".
 */
final class LockExpiredTasks_SchedulerService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulerService.class.getMethod("lockExpiredTasks");
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulerService.class.getName(), "lockExpiredTasks(null)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Initialize object. All parameters from method "lockExpiredTasks" have to be passed as parameters to this command
   * object.
   * 
   * 
   */
  LockExpiredTasks_SchedulerService_Command( ) {
    super(SchedulerService.class);
    parameters = new Object[] {};
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulerService lService = (SchedulerService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    Serializable lResult = (Serializable) lService.lockExpiredTasks();
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    return lResult;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "executeTask".
 */
final class ExecuteTask_ScheduledTask_SchedulerService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulerService.class.getMethod("executeTask", ScheduledTask.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulerService.class.getName(), "executeTask(ScheduledTask.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Initialize object. All parameters from method "executeTask" have to be passed as parameters to this command object.
   * 
   * @param pTask ScheduledTask
   */
  ExecuteTask_ScheduledTask_SchedulerService_Command( ScheduledTask pTask ) {
    super(SchedulerService.class);
    task = pTask;
    parameters = new Object[] { task };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) throws SchedulingSystemException {
    // Execute service call.
    SchedulerService lService = (SchedulerService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    lService.executeTask(task);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    // Method has no return type thus the method returns null.
    return null;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "addExecutionResult".
 */
final class AddExecutionResult_ScheduledTask_Exception_ExecutionTrigger_SchedulerService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulerService.class.getMethod("addExecutionResult", ScheduledTask.class, Exception.class,
          ExecutionTrigger.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulerService.class.getName(),
        "addExecutionResult(ScheduledTask.class, Exception.class, ExecutionTrigger.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Attribute transports the method parameter "pExecutionException" to the service implementation via the service
   * channel.
   */
  private final Exception executionException;

  /**
   * Attribute transports the method parameter "pTrigger" to the service implementation via the service channel.
   */
  private final ExecutionTrigger trigger;

  /**
   * Initialize object. All parameters from method "addExecutionResult" have to be passed as parameters to this command
   * object.
   * 
   * @param pTask ScheduledTask
   * @param pExecutionException Exception
   * @param pTrigger ExecutionTrigger
   */
  AddExecutionResult_ScheduledTask_Exception_ExecutionTrigger_SchedulerService_Command( ScheduledTask pTask,
      Exception pExecutionException, ExecutionTrigger pTrigger ) {
    super(SchedulerService.class);
    task = pTask;
    executionException = pExecutionException;
    trigger = pTrigger;
    parameters = new Object[] { task, executionException, trigger };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulerService lService = (SchedulerService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    lService.addExecutionResult(task, executionException, trigger);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    // Method has no return type thus the method returns null.
    return null;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}
