package com.anaptecs.jeaf.services.scheduling;

import com.anaptecs.jeaf.xfun.annotations.MessageResource;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.messages.MessageRepository;

/**
 * Class for Error Codes for the Scheduling
 *
 * @author JEAF Development Team
 * @version 1.0
 */
@MessageResource(path = "SchedulingMessages.xml")
public final class SchedulingMessages {
  /**
   * Constant for XML file that contains all messages that are defined within this class.
   */
  private static final String MESSAGE_RESOURCE = "SchedulingMessages.xml";

  /**
   * Error code is used to indicate that no ExecutionStrategy was given for the Task.
   */
  public static final ErrorCode NO_EXECUTION_STRATEGY_SET;

  /**
   * Error code is used to indicate that the Serialization failed because of an IOException.
   */
  public static final ErrorCode ERROR_DURING_SERIALIZATION;

  /**
   * Error code is used to indicate that the Deserialization failed because of an IOException.
   */
  public static final ErrorCode ERROR_DURING_DESERIALIZATION;

  /**
   * Error code is used to indicate that the Deserialization failed because of an ClassNotFoundException.
   */
  public static final ErrorCode ERROR_DURING_DESERIALIZATION_CLASS_NOT_FOUND;

  /**
   * Error code is used to indicate that the Task which should be unscheduled could not be found.
   */
  public static final ErrorCode NO_TASK_FOUND_FOR_UNSCHEDULING;

  /**
   * Error code is used to indicate that the ServiceClass of the Task does not implement the SchedulableService
   * interface.
   */
  public static final ErrorCode SERVICE_CLASS_IS_NOT_SCHEDULEABLE_SERVICE;

  /**
   * Error code is used to indicate that the Task which is going to be executed must be locked.
   */
  public static final ErrorCode TASK_IS_NOT_LOCKED_FOR_EXECUTION;

  /**
   * Error code is used to indicate that the Task which is going to be executed must be locked and therefore needs to be
   * scheduled.
   */
  public static final ErrorCode TASK_IN_WRONG_STATE_FOR_LOCKING;

  /**
   * Error code is used to indicate that the Exception is thrown for testing purposes.
   */
  public static final ErrorCode TEST_EXCEPTION;
  /**
   * Static initializer contains initialization for all generated constants.
   */
  static {
    MessageRepository lRepository = XFun.getMessageRepository();
    lRepository.loadResource(MESSAGE_RESOURCE);
    // Handle all info messages.
    // Handle all messages for errors.
    NO_EXECUTION_STRATEGY_SET = lRepository.getErrorCode(850);
    ERROR_DURING_SERIALIZATION = lRepository.getErrorCode(851);
    ERROR_DURING_DESERIALIZATION = lRepository.getErrorCode(852);
    ERROR_DURING_DESERIALIZATION_CLASS_NOT_FOUND = lRepository.getErrorCode(853);
    NO_TASK_FOUND_FOR_UNSCHEDULING = lRepository.getErrorCode(854);
    SERVICE_CLASS_IS_NOT_SCHEDULEABLE_SERVICE = lRepository.getErrorCode(855);
    TASK_IS_NOT_LOCKED_FOR_EXECUTION = lRepository.getErrorCode(856);
    TASK_IN_WRONG_STATE_FOR_LOCKING = lRepository.getErrorCode(857);
    TEST_EXCEPTION = lRepository.getErrorCode(858);
    // Handle all localized strings.
  }

  /**
   * Constructor is private to ensure that no instances of this class will be created.
   */
  private SchedulingMessages( ) {
    // Nothing to do.
  }
}