/*
 * anaptecs GmbH, Ricarda-Huch-Str. 71, 72760 Reutlingen, Germany
 * 
 * Copyright 2004 - 2019. All rights reserved.
 */
package com.anaptecs.jeaf.services.scheduling;

import java.util.Set;

import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.api.ServiceObjectID;

/**
 * @author JEAF Generator
 * @version JEAF Release 1.4.x
 */
public interface SchedulingService extends Service {
  /**
   * Method creates a new scheduled task object. The initial state of the task will be scheduled. Depending on the
   * executing strategy the next execution time will be determined. The passed object must also define a execution
   * strategy and may contain optional scheduling information.
   * 
   * 
   * @param pTask Task object that should be scheduled. The parameter must not be null.
   * 
   * @return {@link ScheduledTask} Object describing the created scheduled task. The method never returns null.
   * 
   * @throws {@link SchedulingApplicationException}
   */
  ScheduledTask scheduleTask( ScheduledTask pTask ) throws SchedulingApplicationException;

  /**
   * 
   * @param pTask
   * @return {@link ScheduledTask}
   */
  ScheduledTask unscheduleTask( ScheduledTask pTask );

  /**
   * 
   * @param pQuery
   * @return {@link ScheduledTask}
   */
  Set<ScheduledTask> queryTasks( ScheduledTaskQuery pQuery );

  /**
   * 
   * @param pTask
   */
  void deleteTask( ScheduledTask pTask );

  /**
   * 
   * @param pTaskID
   * @return {@link ScheduledTask}
   */
  ScheduledTask getTask( ServiceObjectID pTaskID );

  /**
   * 
   * @param pTask
   */
  void startTask( ScheduledTask pTask );
}
