/*
 * anaptecs GmbH, Ricarda-Huch-Str. 71, 72760 Reutlingen, Germany
 * 
 * Copyright 2004 - 2019. All rights reserved.
 */
package com.anaptecs.jeaf.services.scheduling;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.api.ServiceObjectID;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.core.servicechannel.api.ServiceProxy;
import com.anaptecs.jeaf.core.spi.TransactionBehavior;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ApplicationException;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;

/**
 * ServiceProxy class for JEAF service SchedulingService.
 */
public final class SchedulingServiceProxy extends ServiceProxy implements SchedulingService {
  /**
   * Serial version uid for the proxy class.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Initialize object.
   *
   * @param pTransactionBehavior Definition of transactional behavior. The Parameter must not be null.
   */
  public SchedulingServiceProxy( TransactionBehavior pTransactionBehavior ) {
    super(SchedulingService.class, pTransactionBehavior);
  }

  /**
   * Generated proxy implementation for method "scheduleTask".
   * 
   * Method creates a new scheduled task object. The initial state of the task will be scheduled. Depending on the
   * executing strategy the next execution time will be determined. The passed object must also define a execution
   * strategy and may contain optional scheduling information.
   */
  public ScheduledTask scheduleTask( ScheduledTask pTask ) throws SchedulingApplicationException {
    try {
      Command lCommand = new ScheduleTask_ScheduledTask_SchedulingService_Command(pTask);
      return (ScheduledTask) this.executeCommand(lCommand);
    }
    catch (SchedulingApplicationException e) {
      throw e;
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "unscheduleTask".
   * 
   * 
   */
  public ScheduledTask unscheduleTask( ScheduledTask pTask ) {
    try {
      Command lCommand = new UnscheduleTask_ScheduledTask_SchedulingService_Command(pTask);
      return (ScheduledTask) this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "queryTasks".
   * 
   * 
   */
  @SuppressWarnings("unchecked")
  public Set<ScheduledTask> queryTasks( ScheduledTaskQuery pQuery ) {
    try {
      Command lCommand = new QueryTasks_ScheduledTaskQuery_SchedulingService_Command(pQuery);
      return (Set<ScheduledTask>) this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "deleteTask".
   * 
   * 
   */
  public void deleteTask( ScheduledTask pTask ) {
    try {
      Command lCommand = new DeleteTask_ScheduledTask_SchedulingService_Command(pTask);
      this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "getTask".
   * 
   * 
   */
  public ScheduledTask getTask( ServiceObjectID pTaskID ) {
    try {
      Command lCommand = new GetTask_ServiceObjectID_SchedulingService_Command(pTaskID);
      return (ScheduledTask) this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }

  /**
   * Generated proxy implementation for method "startTask".
   * 
   * 
   */
  public void startTask( ScheduledTask pTask ) {
    try {
      Command lCommand = new StartTask_ScheduledTask_SchedulingService_Command(pTask);
      this.executeCommand(lCommand);
    }
    catch (ApplicationException e) {
      throw new JEAFSystemException(e.getErrorCode(), e.getMessageParameters(), e);
    }
  }
}

/**
 * Generated command class for service method "scheduleTask".
 */
final class ScheduleTask_ScheduledTask_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("scheduleTask", ScheduledTask.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "scheduleTask(ScheduledTask.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Initialize object. All parameters from method "scheduleTask" have to be passed as parameters to this command
   * object.
   * 
   * @param pTask ScheduledTask
   */
  ScheduleTask_ScheduledTask_SchedulingService_Command( ScheduledTask pTask ) {
    super(SchedulingService.class);
    task = pTask;
    parameters = new Object[] { task };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) throws SchedulingApplicationException {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    Serializable lResult = (Serializable) lService.scheduleTask(task);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    return lResult;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "unscheduleTask".
 */
final class UnscheduleTask_ScheduledTask_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("unscheduleTask", ScheduledTask.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "unscheduleTask(ScheduledTask.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Initialize object. All parameters from method "unscheduleTask" have to be passed as parameters to this command
   * object.
   * 
   * @param pTask ScheduledTask
   */
  UnscheduleTask_ScheduledTask_SchedulingService_Command( ScheduledTask pTask ) {
    super(SchedulingService.class);
    task = pTask;
    parameters = new Object[] { task };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    Serializable lResult = (Serializable) lService.unscheduleTask(task);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    return lResult;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "queryTasks".
 */
final class QueryTasks_ScheduledTaskQuery_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("queryTasks", ScheduledTaskQuery.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "queryTasks(ScheduledTaskQuery.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pQuery" to the service implementation via the service channel.
   */
  private final ScheduledTaskQuery query;

  /**
   * Initialize object. All parameters from method "queryTasks" have to be passed as parameters to this command object.
   * 
   * @param pQuery ScheduledTaskQuery
   */
  QueryTasks_ScheduledTaskQuery_SchedulingService_Command( ScheduledTaskQuery pQuery ) {
    super(SchedulingService.class);
    query = pQuery;
    parameters = new Object[] { query };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    Serializable lResult = (Serializable) lService.queryTasks(query);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    return lResult;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "deleteTask".
 */
final class DeleteTask_ScheduledTask_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("deleteTask", ScheduledTask.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "deleteTask(ScheduledTask.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Initialize object. All parameters from method "deleteTask" have to be passed as parameters to this command object.
   * 
   * @param pTask ScheduledTask
   */
  DeleteTask_ScheduledTask_SchedulingService_Command( ScheduledTask pTask ) {
    super(SchedulingService.class);
    task = pTask;
    parameters = new Object[] { task };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    lService.deleteTask(task);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    // Method has no return type thus the method returns null.
    return null;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "getTask".
 */
final class GetTask_ServiceObjectID_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("getTask", ServiceObjectID.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "getTask(ServiceObjectID.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTaskID" to the service implementation via the service channel.
   */
  private final ServiceObjectID taskID;

  /**
   * Initialize object. All parameters from method "getTask" have to be passed as parameters to this command object.
   * 
   * @param pTaskID ServiceObjectID
   */
  GetTask_ServiceObjectID_SchedulingService_Command( ServiceObjectID pTaskID ) {
    super(SchedulingService.class);
    taskID = pTaskID;
    parameters = new Object[] { taskID };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    Serializable lResult = (Serializable) lService.getTask(taskID);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    return lResult;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}

/**
 * Generated command class for service method "startTask".
 */
final class StartTask_ScheduledTask_SchedulingService_Command extends Command {
  /**
   * Default serial version uid.
   */
  private static final long serialVersionUID = 1L;

  /**
   * Constant for factor to convert nano seconds to milliseconds.
   */
  private static final int MILLISECONDS = 1000 * 1000;

  /**
   * Constant describes the service method that is called by this proxy class.
   */
  private static final Method SERVICE_METHOD;

  /**
   * Object array with all parameters that are passed to the service.
   */
  private final Object[] parameters;
  /**
   * Initializer is used to get the method object describing the called service method only once.
   */
  static {
    try {
      SERVICE_METHOD = SchedulingService.class.getMethod("startTask", ScheduledTask.class);
    }
    catch (NoSuchMethodException e) {
      ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
      String[] lParams = new String[] { SchedulingService.class.getName(), "startTask(ScheduledTask.class)" };
      throw new JEAFSystemException(lErrorCode, lParams, e);
    }
  }

  /**
   * Attribute transports the method parameter "pTask" to the service implementation via the service channel.
   */
  private final ScheduledTask task;

  /**
   * Initialize object. All parameters from method "startTask" have to be passed as parameters to this command object.
   * 
   * @param pTask ScheduledTask
   */
  StartTask_ScheduledTask_SchedulingService_Command( ScheduledTask pTask ) {
    super(SchedulingService.class);
    task = pTask;
    parameters = new Object[] { task };
  }

  /**
   * Method executes the service call represented by this command object via JEAFs service channel.
   * 
   * @param pTargetService Reference to the service which should be called by this command. The parameter must not be
   * null.
   * @return Serializable Result object of the service call. Due to the fact that all returned objects of remote calls
   * in Java (EJBs e.g.) have to be serializable services always have to return serializable objects no matter if it
   * will be serialized or not. If a service method has no return type (void) then the method returns null. Service
   * methods also may return null as return value.
   */
  @Override
  public Serializable execute( Service pTargetService ) {
    // Execute service call.
    SchedulingService lService = (SchedulingService) pTargetService;
    // Trace service call.
    Trace lTrace = XFun.getTrace();
    lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, this.getCalledServiceMethod());
    long lStartTime = System.nanoTime();
    lService.startTask(task);
    // Calculate duration of service call in milliseconds
    String lDuration = Long.toString((System.nanoTime() - lStartTime) / MILLISECONDS);
    // Trace result of service call.
    lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, this.getCalledServiceMethod(), lDuration);
    // Method has no return type thus the method returns null.
    return null;
  }

  /**
   * Method returns a method object describing the service method that will be called by this command object.
   * 
   * @return {@link Method} Method object describing the called service method. The method never returns null.
   */
  @Override
  public final Method getServiceMethod( ) {
    return SERVICE_METHOD;
  }

  /**
   * Method returns all parameters that will be passed to the service.
   * 
   * @return {@link Object} Object array with all parameters that will be passed to the service. The method may return
   * an empty array in case that the method has no parameters.
   */
  @Override
  public Object[] getParameters( ) {
    return parameters;
  }
}
