/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.scheduling;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.services.scheduling.ScheduledTask;
import com.anaptecs.jeaf.services.scheduling.SchedulerService;
import com.anaptecs.jeaf.services.scheduling.SchedulingSystemException;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;

final class ExecuteTask_ScheduledTask_SchedulerService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final ScheduledTask task;

    ExecuteTask_ScheduledTask_SchedulerService_Command(ScheduledTask pTask) {
        super(SchedulerService.class);
        this.task = pTask;
        this.parameters = new Object[]{this.task};
    }

    public Serializable execute(Service pTargetService) throws SchedulingSystemException {
        SchedulerService lService = (SchedulerService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        lService.executeTask(this.task);
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return null;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = SchedulerService.class.getMethod("executeTask", ScheduledTask.class);
        }
        catch (NoSuchMethodException e) {
            ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
            String[] lParams = new String[]{SchedulerService.class.getName(), "executeTask(ScheduledTask.class)"};
            throw new JEAFSystemException(lErrorCode, lParams, (Throwable)e);
        }
    }
}

