/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.scheduling;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.services.scheduling.ScheduledTaskQuery;
import com.anaptecs.jeaf.services.scheduling.SchedulingService;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;

final class QueryTasks_ScheduledTaskQuery_SchedulingService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final ScheduledTaskQuery query;

    QueryTasks_ScheduledTaskQuery_SchedulingService_Command(ScheduledTaskQuery pQuery) {
        super(SchedulingService.class);
        this.query = pQuery;
        this.parameters = new Object[]{this.query};
    }

    public Serializable execute(Service pTargetService) {
        SchedulingService lService = (SchedulingService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        Serializable lResult = (Serializable)((Object)lService.queryTasks(this.query));
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return lResult;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = SchedulingService.class.getMethod("queryTasks", ScheduledTaskQuery.class);
        }
        catch (NoSuchMethodException e) {
            ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
            String[] lParams = new String[]{SchedulingService.class.getName(), "queryTasks(ScheduledTaskQuery.class)"};
            throw new JEAFSystemException(lErrorCode, lParams, (Throwable)e);
        }
    }
}

