/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.systemmanagement;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.services.systemmanagement.ApplicationLocalization;
import com.anaptecs.jeaf.services.systemmanagement.LocalizationAdminService;
import com.anaptecs.jeaf.services.systemmanagement.LocalizationApplicationException;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;

final class CreateApplicationLocalization_ApplicationLocalization_LocalizationAdminService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final ApplicationLocalization application;

    CreateApplicationLocalization_ApplicationLocalization_LocalizationAdminService_Command(ApplicationLocalization pApplication) {
        super(LocalizationAdminService.class);
        this.application = pApplication;
        this.parameters = new Object[]{this.application};
    }

    public Serializable execute(Service pTargetService) throws LocalizationApplicationException {
        LocalizationAdminService lService = (LocalizationAdminService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        ApplicationLocalization lResult = lService.createApplicationLocalization(this.application);
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return lResult;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = LocalizationAdminService.class.getMethod("createApplicationLocalization", ApplicationLocalization.class);
        }
        catch (NoSuchMethodException e) {
            ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
            String[] lParams = new String[]{LocalizationAdminService.class.getName(), "createApplicationLocalization(ApplicationLocalization.class)"};
            throw new JEAFSystemException(lErrorCode, lParams, (Throwable)e);
        }
    }
}

