/*
 * Decompiled with CFR 0.152.
 */
package com.anaptecs.jeaf.services.systemmanagement;

import com.anaptecs.jeaf.core.api.MessageConstants;
import com.anaptecs.jeaf.core.api.Service;
import com.anaptecs.jeaf.core.servicechannel.api.Command;
import com.anaptecs.jeaf.services.systemmanagement.ComponentInfo;
import com.anaptecs.jeaf.services.systemmanagement.Property;
import com.anaptecs.jeaf.services.systemmanagement.PropertyAdminService;
import com.anaptecs.jeaf.services.systemmanagement.PropertyApplicationException;
import com.anaptecs.jeaf.xfun.api.XFun;
import com.anaptecs.jeaf.xfun.api.errorhandling.ErrorCode;
import com.anaptecs.jeaf.xfun.api.errorhandling.JEAFSystemException;
import com.anaptecs.jeaf.xfun.api.trace.Trace;
import java.io.Serializable;
import java.lang.reflect.Method;

final class CreateProperty_Property_ComponentInfo_PropertyAdminService_Command
extends Command {
    private static final long serialVersionUID = 1L;
    private static final int MILLISECONDS = 1000000;
    private static final Method SERVICE_METHOD;
    private final Object[] parameters;
    private final Property property;
    private final ComponentInfo componentInfo;

    CreateProperty_Property_ComponentInfo_PropertyAdminService_Command(Property pProperty, ComponentInfo pComponentInfo) {
        super(PropertyAdminService.class);
        this.property = pProperty;
        this.componentInfo = pComponentInfo;
        this.parameters = new Object[]{this.property, this.componentInfo};
    }

    public Serializable execute(Service pTargetService) throws PropertyApplicationException {
        PropertyAdminService lService = (PropertyAdminService)pTargetService;
        Trace lTrace = XFun.getTrace();
        lTrace.write(MessageConstants.EXECUTING_SERVICE_CALL, new String[]{this.getCalledServiceMethod()});
        long lStartTime = System.nanoTime();
        Property lResult = lService.createProperty(this.property, this.componentInfo);
        String lDuration = Long.toString((System.nanoTime() - lStartTime) / 1000000L);
        lTrace.write(MessageConstants.RETURNING_FROM_SERVICE_CALL, new String[]{this.getCalledServiceMethod(), lDuration});
        return lResult;
    }

    public final Method getServiceMethod() {
        return SERVICE_METHOD;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    static {
        try {
            SERVICE_METHOD = PropertyAdminService.class.getMethod("createProperty", Property.class, ComponentInfo.class);
        }
        catch (NoSuchMethodException e) {
            ErrorCode lErrorCode = MessageConstants.SERVICE_METHOD_DOES_NOT_EXIST;
            String[] lParams = new String[]{PropertyAdminService.class.getName(), "createProperty(Property.class, ComponentInfo.class)"};
            throw new JEAFSystemException(lErrorCode, lParams, (Throwable)e);
        }
    }
}

